/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.scripting.pool;

public final class DynamicPoolConfig {
    private static final int numberOfObjects_def = 1;
    private static final int maxGeneratingObjects_def = 1;
    private static final int hardMaxActiveObjects_def = 2;
    private static final int hardMinActiveObjects_def = 1;
    private static final int downThreashold_def = 10;
    private static final int queueThreashold_def = 10;
    private static final int newThreashold_def = 10;
    private static final boolean dynamic_def = true;
    private static final boolean asyncEnabled_def = true;
    private static final boolean validate_def = false;
    private int numberOfObjects;
    private int maxGeneratingObjects;
    private int hardMaxActiveObjects;
    private int hardMinActiveObjects;
    private int downThreashold;
    private int queueThreashold;
    private int newThreashold;
    private boolean dynamic;
    private boolean asyncEnabled;
    private boolean validate;

    public DynamicPoolConfig() {
        this.numberOfObjects = 1;
        this.maxGeneratingObjects = 1;
        this.hardMaxActiveObjects = 2;
        this.hardMinActiveObjects = 1;
        this.downThreashold = 10;
        this.queueThreashold = 10;
        this.newThreashold = 10;
        this.dynamic = true;
        this.asyncEnabled = true;
        this.validate = false;
    }

    public DynamicPoolConfig(int startingNumber, int maxGenerating, int hardMax, int hardMin, int downThresh, int queueThresh, int newThresh, boolean async, boolean validation) {
        this.numberOfObjects = startingNumber > 0 ? startingNumber : 1;
        this.maxGeneratingObjects = maxGenerating > 0 ? maxGenerating : 1;
        this.hardMaxActiveObjects = hardMax > 0 && hardMax >= this.numberOfObjects ? hardMax : Math.max(2, this.numberOfObjects);
        this.hardMinActiveObjects = hardMin > 0 && hardMin <= this.numberOfObjects ? (hardMin > this.numberOfObjects ? this.numberOfObjects : hardMin) : 1;
        this.downThreashold = downThresh > 0 ? downThresh : 10;
        this.queueThreashold = queueThresh > 0 ? queueThresh : 10;
        this.newThreashold = newThresh > 0 ? newThresh : 10;
        this.asyncEnabled = async;
        this.validate = validation;
        String dynamicEnable = System.getProperty("jruby.runtime.dynamic");
        boolean bl = this.dynamic = dynamicEnable == null || Boolean.valueOf(dynamicEnable) != false;
        if (this.hardMaxActiveObjects == this.numberOfObjects && this.numberOfObjects == this.hardMinActiveObjects) {
            this.dynamic = false;
        }
    }

    public boolean shouldValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public int getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public void setNumberOfObjects(int numberOfObjects) {
        this.numberOfObjects = numberOfObjects > 0 ? numberOfObjects : 1;
    }

    public int getMaxGeneratingObjects() {
        return this.maxGeneratingObjects;
    }

    public void setMaxGeneratingObjects(int maxGeneratingObjects) {
        this.maxGeneratingObjects = maxGeneratingObjects > 0 ? maxGeneratingObjects : 1;
    }

    public int getHardMaxActiveObjects() {
        return this.hardMaxActiveObjects;
    }

    public void setHardMaxActiveObjects(int hardMaxActiveObjects) {
        this.hardMaxActiveObjects = hardMaxActiveObjects > 0 ? hardMaxActiveObjects : 2;
        if (this.hardMaxActiveObjects < this.hardMinActiveObjects) {
            this.hardMinActiveObjects = this.hardMaxActiveObjects;
        }
    }

    public int getHardMinActiveObjects() {
        return this.hardMinActiveObjects;
    }

    public void setHardMinActiveObjects(int hardMinActiveObjects) {
        this.hardMinActiveObjects = hardMinActiveObjects > 0 && hardMinActiveObjects <= this.hardMaxActiveObjects ? hardMinActiveObjects : Math.min(1, this.hardMaxActiveObjects);
    }

    public int getDownThreashold() {
        return this.downThreashold;
    }

    public void setDownThreashold(int downThreashold) {
        this.downThreashold = downThreashold > 0 ? downThreashold : 10;
    }

    public int getQueueThreashold() {
        return this.queueThreashold;
    }

    public void setQueueThreashold(int queueThreashold) {
        this.queueThreashold = queueThreashold > 0 ? queueThreashold : 10;
    }

    public int getNewThreashold() {
        return this.newThreashold;
    }

    public void setNewThreashold(int newThreashold) {
        this.newThreashold = newThreashold > 0 ? newThreashold : 10;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this.asyncEnabled = asyncEnabled;
    }
}

