/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.RegistrationDocument;
import com.sun.servicetag.ServiceTag;
import com.sun.servicetag.SystemEnvironment;
import com.sun.servicetag.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationData {
    private final Map<String, String> environment;
    private final Map<String, ServiceTag> svcTagMap;
    private final String urn;

    public RegistrationData() {
        this(Util.generateURN());
    }

    RegistrationData(String urn) {
        this.urn = urn;
        this.environment = this.initEnvironment();
        this.svcTagMap = new LinkedHashMap<String, ServiceTag>();
    }

    private Map<String, String> initEnvironment() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        SystemEnvironment sysEnv = SystemEnvironment.getSystemEnvironment();
        map.put("hostname", sysEnv.getHostname());
        map.put("hostId", sysEnv.getHostId());
        map.put("osName", sysEnv.getOsName());
        map.put("osVersion", sysEnv.getOsVersion());
        map.put("osArchitecture", sysEnv.getOsArchitecture());
        map.put("systemModel", sysEnv.getSystemModel());
        map.put("systemManufacturer", sysEnv.getSystemManufacturer());
        map.put("cpuManufacturer", sysEnv.getCpuManufacturer());
        map.put("serialNumber", sysEnv.getSerialNumber());
        return map;
    }

    public String getRegistrationURN() {
        return this.urn;
    }

    public Map<String, String> getEnvironmentMap() {
        return new LinkedHashMap<String, String>(this.environment);
    }

    public void setEnvironment(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.environment.containsKey(name)) {
            if ((name.equals("hostname") || name.equals("osName")) && value.length() == 0) {
                throw new IllegalArgumentException("\"" + name + "\" requires non-empty value.");
            }
        } else {
            throw new IllegalArgumentException("\"" + name + "\" is not an environment element.");
        }
        this.environment.put(name, value);
    }

    public Set<ServiceTag> getServiceTags() {
        return new HashSet<ServiceTag>(this.svcTagMap.values());
    }

    public synchronized ServiceTag addServiceTag(ServiceTag st) {
        ServiceTag svcTag = ServiceTag.newInstanceWithUrnTimestamp(st);
        String instanceURN = svcTag.getInstanceURN();
        if (this.svcTagMap.containsKey(instanceURN)) {
            throw new IllegalArgumentException("Instance_urn = " + instanceURN + " already exists in the registration data.");
        }
        this.svcTagMap.put(instanceURN, svcTag);
        return svcTag;
    }

    public synchronized ServiceTag getServiceTag(String instanceURN) {
        if (instanceURN == null) {
            throw new NullPointerException("instanceURN is null");
        }
        return this.svcTagMap.get(instanceURN);
    }

    public synchronized ServiceTag removeServiceTag(String instanceURN) {
        if (instanceURN == null) {
            throw new NullPointerException("instanceURN is null");
        }
        ServiceTag svcTag = null;
        if (this.svcTagMap.containsKey(instanceURN)) {
            svcTag = this.svcTagMap.remove(instanceURN);
        }
        return svcTag;
    }

    public synchronized ServiceTag updateServiceTag(String instanceURN, String productDefinedInstanceID) {
        ServiceTag svcTag = this.getServiceTag(instanceURN);
        if (svcTag == null) {
            return null;
        }
        svcTag = ServiceTag.newInstanceWithUrnTimestamp(svcTag);
        svcTag.setProductDefinedInstanceID(productDefinedInstanceID);
        this.svcTagMap.put(instanceURN, svcTag);
        return svcTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegistrationData loadFromXML(InputStream in) throws IOException {
        try {
            RegistrationData registrationData = RegistrationDocument.load(in);
            return registrationData;
        }
        finally {
            in.close();
        }
    }

    public void storeToXML(OutputStream os) throws IOException {
        RegistrationDocument.store(os, this);
        os.flush();
    }

    public byte[] toXML() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.storeToXML(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.storeToXML(out);
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            return "Error creating the return string.";
        }
    }
}

