/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupNotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.MapEntry;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

abstract class SelectThread {
    protected Logger logger = Globals.getLogger();
    protected static boolean DEBUG = GroupService.DEBUG;
    protected static final long DEF_TIMEOUT = 120000L;
    protected long TIMEOUT = Globals.getConfig().getLongProperty("imq.shared.timeout", 120000L);
    GroupRunnable parent = null;
    protected String type = "";
    int id = 0;
    private static int LASTID = 0;
    Map all_connections = Collections.synchronizedMap(new HashMap());
    List pending_connections = Collections.synchronizedList(new LinkedList());
    Set cancel_connections = new HashSet();
    HashMap key_con_map = new HashMap();
    Selector selector = null;
    boolean valid = true;
    GroupService svc = null;
    protected int INITIAL_KEY = 0;
    protected int POSSIBLE_MASK = 0;
    private MapEntry selectorListMapEntry = null;
    HashMap reasons = new HashMap();
    List cancellist = new ArrayList();

    public String getStateInfo() {
        return "[svc,item] = " + this.svc + "," + this.selectorListMapEntry + " [a,p,c] = " + this.all_connections.size() + "," + this.pending_connections.size() + "," + this.cancel_connections.size() + "]";
    }

    protected static String keyMaskToString(int n) {
        String string = "";
        if ((n & 0x10) == 16) {
            string = string + "OP_ACCEPT ";
        }
        if ((n & 8) == 8) {
            string = string + "OP_CONNECT ";
        }
        if ((n & 1) == 1) {
            string = string + "OP_READ ";
        }
        if ((n & 4) == 4) {
            string = string + "OP_WRITE";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Hashtable getDebugState() {
        Collection<Object> collection;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("INITIAL_KEY", SelectThread.keyMaskToString(this.INITIAL_KEY));
        hashtable.put("POSSIBLE_MASK", SelectThread.keyMaskToString(this.POSSIBLE_MASK));
        hashtable.put("valid", this.valid);
        Object object = this.all_connections;
        synchronized (object) {
            hashtable.put("all_connections#", new Integer(this.all_connections.size()));
            collection = new Vector<Long>();
            for (Iterator iterator : this.all_connections.values()) {
                ((Vector)collection).add(new Long(((Connection)((Object)iterator)).getConnectionUID().longValue()));
            }
            hashtable.put("all_connections", collection);
        }
        object = this.pending_connections;
        synchronized (object) {
            hashtable.put("pending_connections#", new Integer(this.pending_connections.size()));
        }
        object = this.cancel_connections;
        synchronized (object) {
            hashtable.put("cancel_connections#", new Integer(this.cancel_connections.size()));
        }
        if (this.selector != null) {
            IMQIPConnection iMQIPConnection;
            int n = 0;
            try {
                this.selector.wakeup();
                n = this.selector.selectNow();
            }
            catch (Exception exception) {
                this.logger.log(1, "Exception in select ", (Throwable)exception);
            }
            hashtable.put("selector(cnt)", new Integer(n));
            collection = this.selector.selectedKeys();
            hashtable.put("selector(selectedKeys#)", new Integer(collection.size()));
            Vector<String> vector = new Vector();
            for (SelectionKey selectionKey : collection) {
                iMQIPConnection = (IMQIPConnection)selectionKey.attachment();
                vector.add("interest=" + SelectThread.keyMaskToString(selectionKey.interestOps()) + " ready=" + SelectThread.keyMaskToString(selectionKey.readyOps()) + " conuid = " + (iMQIPConnection == null ? "none" : String.valueOf(iMQIPConnection.getConnectionUID().longValue())));
            }
            hashtable.put("Selector(selectedKeys)", vector);
            collection = this.selector.keys();
            hashtable.put("selector(keys#)", new Integer(collection.size()));
            vector = new Vector<String>();
            for (SelectionKey selectionKey : collection) {
                iMQIPConnection = (IMQIPConnection)selectionKey.attachment();
                vector.add("interest=" + SelectThread.keyMaskToString(selectionKey.interestOps()) + " ready=" + SelectThread.keyMaskToString(selectionKey.readyOps()) + " conuid = " + (iMQIPConnection == null ? "none" : String.valueOf(iMQIPConnection.getConnectionUID().longValue())));
            }
            hashtable.put("Selector(keys)", vector);
        }
        return hashtable;
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    public void assign(GroupRunnable groupRunnable) {
        this.parent = groupRunnable;
    }

    public GroupRunnable getParent() {
        return this.parent;
    }

    public void free(GroupRunnable groupRunnable) {
        this.destroy("Unknown free");
        this.parent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectThread(Service service, MapEntry mapEntry) throws IOException {
        this.selector = Selector.open();
        this.svc = (GroupService)service;
        this.selectorListMapEntry = mapEntry;
        Class<SelectThread> clazz = SelectThread.class;
        synchronized (SelectThread.class) {
            this.id = LASTID++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int size() {
        return this.all_connections.size();
    }

    public int totalSize() {
        return this.all_connections.size() + this.pending_connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewConnection(IMQIPConnection iMQIPConnection) throws IOException {
        List list = this.pending_connections;
        synchronized (list) {
            if (!this.isValid()) {
                throw new IOException(this + " has been destroyed ");
            }
            this.pending_connections.add(iMQIPConnection);
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(IMQIPConnection iMQIPConnection, String string) throws IOException {
        SelectionKey selectionKey = null;
        HashMap hashMap = this.key_con_map;
        synchronized (hashMap) {
            selectionKey = (SelectionKey)this.key_con_map.get((Object)iMQIPConnection.getConnectionUID());
        }
        if (selectionKey != null) {
            this.changeInterest(selectionKey, -1, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionKey processPendingConnection(IMQIPConnection iMQIPConnection) throws IOException {
        if (iMQIPConnection == null) {
            return null;
        }
        Object object = this.all_connections;
        synchronized (object) {
            this.all_connections.put(iMQIPConnection.getConnectionUID(), iMQIPConnection);
        }
        object = iMQIPConnection.getChannel();
        if (object == null) {
            throw new IOException("Connection " + iMQIPConnection + " no longer has a valid channel");
        }
        SelectionKey selectionKey = ((SelectableChannel)object).register(this.selector, this.INITIAL_KEY);
        if (selectionKey == null) {
            return null;
        }
        selectionKey.attach(iMQIPConnection);
        GroupNotificationInfo groupNotificationInfo = (GroupNotificationInfo)iMQIPConnection.attachment();
        if (groupNotificationInfo == null) {
            return null;
        }
        groupNotificationInfo.setThread(this.POSSIBLE_MASK, this, selectionKey);
        HashMap hashMap = this.key_con_map;
        synchronized (hashMap) {
            this.key_con_map.put(iMQIPConnection.getConnectionUID(), selectionKey);
        }
        return selectionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeInterest(SelectionKey selectionKey, int n, String string) throws IOException {
        if (n == -1) {
            Set set = this.cancel_connections;
            synchronized (set) {
                this.cancel_connections.add(selectionKey);
                this.reasons.put(selectionKey, string);
            }
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(String string) {
        Object object = this;
        synchronized (object) {
            this.valid = false;
        }
        if (this.selector != null) {
            try {
                object = this.all_connections;
                synchronized (object) {
                    for (IMQIPConnection iMQIPConnection : this.all_connections.values()) {
                        this.removeConnection(iMQIPConnection, string);
                    }
                }
                this.selector.close();
            }
            catch (IOException iOException) {
                this.logger.log(4, "exception closing", (Throwable)iOException);
            }
            finally {
                this.selector = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processThread() throws Exception {
        Object object;
        Object object2;
        while (true) {
            if (!this.valid) {
                this.logger.log(4, "SelectThread " + this + " no longer valid");
                break;
            }
            object2 = null;
            object = this.pending_connections;
            synchronized (object) {
                if (this.pending_connections.size() <= 0) {
                    break;
                }
                object2 = (IMQIPConnection)this.pending_connections.remove(0);
            }
            try {
                this.processPendingConnection((IMQIPConnection)object2);
            }
            catch (IOException iOException) {
                this.logger.logStack(4, "Exception on pending con " + object2 + " : can not process", (Throwable)iOException);
            }
        }
        object2 = null;
        object = this.cancel_connections;
        synchronized (object) {
            if (this.cancel_connections.size() > 0) {
                object2 = new HashMap();
                if (this.reasons != null) {
                    ((HashMap)object2).putAll(this.reasons);
                }
                this.cancellist.clear();
                this.cancellist.addAll(this.cancel_connections);
                this.cancel_connections.clear();
                this.reasons.clear();
            }
        }
        if (this.cancellist.size() > 0) {
            for (SelectionKey selectionKey : this.cancellist) {
                Object object3;
                IMQIPConnection iMQIPConnection = (IMQIPConnection)selectionKey.attachment();
                SelectableChannel selectableChannel = selectionKey.channel();
                String string = object2 == null ? "unknown" : (String)((HashMap)object2).remove(selectionKey);
                try {
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                }
                catch (Exception exception) {
                    this.logger.log(4, "exception cancling key", (Throwable)exception);
                }
                try {
                    if (selectableChannel != null) {
                        object3 = ((SocketChannel)selectableChannel).socket();
                        selectableChannel.close();
                        ((Socket)object3).close();
                    }
                }
                catch (Exception exception) {
                    this.logger.log(4, "closing ", (Throwable)exception);
                }
                try {
                    object3 = this.pending_connections;
                    synchronized (object3) {
                        this.pending_connections.remove(iMQIPConnection);
                    }
                    object3 = this.all_connections;
                    synchronized (object3) {
                        this.all_connections.remove((Object)iMQIPConnection.getConnectionUID());
                    }
                    object3 = this.key_con_map;
                    synchronized (object3) {
                        this.key_con_map.remove((Object)iMQIPConnection.getConnectionUID());
                    }
                }
                catch (Exception exception) {
                    this.logger.log(4, "closing ", (Throwable)exception);
                }
                try {
                    iMQIPConnection.destroyConnection(false, 5, string);
                }
                catch (Exception exception) {
                    this.logger.log(4, "destroying con", (Throwable)exception);
                }
            }
            this.cancellist.clear();
        }
        if (this.valid) {
            try {
                this.process();
            }
            catch (Exception exception) {
                this.logger.logStack(8, "Exception processing " + this, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Map map = this.all_connections;
        synchronized (map) {
            List list = this.pending_connections;
            synchronized (list) {
                SelectThread selectThread = this;
                synchronized (selectThread) {
                    return this.valid && (!this.all_connections.isEmpty() || !this.pending_connections.isEmpty());
                }
            }
        }
    }

    protected abstract void wakeup() throws IOException;

    protected abstract void process() throws IOException;

    public String toString() {
        return "SelectThread[" + this.type + ":" + this.id + "]";
    }
}

