/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;

public class ConnectionManager
extends WeakValueHashMap {
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    long lastConCheck = 0L;
    private int limit = 0;
    public static int pingTimeout = Globals.getConfig().getIntProperty("imq.ping.interval", 120) * 1000;
    public boolean PING_ENABLED = Globals.getConfig().getBooleanProperty("imq.ping.enabled", true);
    private ConnectionWatcher connectionWatcher = null;
    private int destroyCount = 0;
    private int addCount = 0;
    public Object addLock = new Object();

    public ConnectionManager(int n) {
        super("ConnectionManager");
        this.limit = n;
    }

    public Connection matchProperty(String string, Object object) {
        List list = this.getConnectionList(null);
        for (Connection connection : list) {
            Object object2 = connection.getClientData(string);
            if (object != object2 && (object == null || object2 == null || !object.equals(object2))) continue;
            return connection;
        }
        return null;
    }

    public void removeFromClientDataList(String string, Object object) {
        List list = this.getConnectionList(null);
        for (Connection connection : list) {
            Object object2 = connection.getClientData(string);
            if (object2 == null || object == null || !(object2 instanceof List)) continue;
            ((List)object2).remove(object);
        }
    }

    private void startTimer() {
        if (this.PING_ENABLED && this.connectionWatcher == null) {
            this.lastConCheck = System.currentTimeMillis();
            MQTimer mQTimer = Globals.getTimer(true);
            this.connectionWatcher = new ConnectionWatcher();
            try {
                mQTimer.schedule((TimerTask)this.connectionWatcher, (long)pingTimeout, (long)pingTimeout);
            }
            catch (IllegalStateException illegalStateException) {
                this.logger.log(4, "Timer shutting down", (Throwable)illegalStateException);
            }
        }
    }

    private void stopTimer() {
        if (this.connectionWatcher != null) {
            this.connectionWatcher.cancel();
            this.connectionWatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionUID(ConnectionUID connectionUID, ConnectionUID connectionUID2) {
        Object object;
        Object object2 = this.addLock;
        synchronized (object2) {
            if (this.destroyCount > 0) {
                try {
                    this.addLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.addCount;
        }
        try {
            object2 = this;
            synchronized (object2) {
                Object object3 = this.remove((Object)connectionUID2);
                if (object3 != null) {
                    this.put((Object)connectionUID, object3);
                }
            }
            Object var8_8 = null;
            object = this.addLock;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Object object4 = this.addLock;
            synchronized (object4) {
                --this.addCount;
                this.addLock.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            --this.addCount;
            this.addLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) throws BrokerException {
        Object object;
        Object object2 = this.addLock;
        synchronized (object2) {
            if (this.destroyCount > 0) {
                try {
                    this.addLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.addCount;
        }
        try {
            if (this.size() > this.limit) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4059", connection.toString(), String.valueOf(this.limit)), "B4059", null, 500);
            }
            object2 = this;
            synchronized (object2) {
                this.put((Object)connection.getConnectionUID(), connection);
                if (this.size() == 1 && this.PING_ENABLED) {
                    this.startTimer();
                }
            }
            Object var7_6 = null;
            object = this.addLock;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Object object3 = this.addLock;
            synchronized (object3) {
                --this.addCount;
                this.addLock.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            --this.addCount;
            this.addLock.notifyAll();
        }
        if (DEBUG) {
            this.logger.log(4, "B1000", (Object)connection.toString(), (Object)String.valueOf(this.size()));
            this.logCM(1);
        }
    }

    public synchronized Connection getConnection(ConnectionUID connectionUID) {
        return (Connection)this.get((Object)connectionUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionUID connectionUID, boolean bl, int n, String string) {
        Object object;
        if (!this.containsKey((Object)connectionUID)) {
            return;
        }
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyConnectionClose(connectionUID.longValue());
            agent.unregisterConnection(connectionUID.longValue());
        }
        Object object2 = this.addLock;
        synchronized (object2) {
            if (this.addCount > 0) {
                try {
                    this.addLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.destroyCount;
        }
        try {
            object2 = null;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                object2 = (Connection)this.remove((Object)connectionUID);
                if (this.size() == 0 && this.PING_ENABLED) {
                    this.stopTimer();
                }
            }
            if (object2 != null) {
                this.destroyConnectionData((Connection)object2, bl, n, string);
            }
            Object var11_11 = null;
            object = this.addLock;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Object object3 = this.addLock;
            synchronized (object3) {
                --this.destroyCount;
                this.addLock.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            --this.destroyCount;
            this.addLock.notifyAll();
        }
    }

    private void destroyConnectionData(Connection connection, boolean bl, int n, String string) {
        if (connection == null) {
            return;
        }
        if (DEBUG) {
            this.logger.log(4, "B1008", (Object)connection.toString(), (Object)String.valueOf(this.size()));
        }
        if (n == 1) {
            connection.shutdownConnection(string);
        } else {
            connection.destroyConnection(bl, n, string);
        }
        if (DEBUG) {
            this.logCM(1);
        }
    }

    private void logCM(int n) {
        this.logger.log(n, "ConnectionManager: " + this.size());
        Set set = this.entrySet();
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.logger.log(n, "{0}:{1}", (Object)String.valueOf(n2), (Object)iterator.next().toString());
            ++n2;
        }
    }

    public Vector getDebugState(Service service) {
        List list = this.getConnectionList(service);
        Vector<String> vector = new Vector<String>();
        for (int i = list.size() - 1; i >= 0; --i) {
            Connection connection = (Connection)list.get(i);
            vector.add(String.valueOf(connection.getConnectionUID().longValue()));
        }
        return vector;
    }

    public synchronized int getNumConnections(Service service) {
        int n = 0;
        for (Connection connection : this.values()) {
            if (service != null && connection.getService() != service) continue;
            ++n;
        }
        return n;
    }

    public synchronized List getConnectionList(Service service) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (Connection connection : this.values()) {
            if (service != null && connection.getService() != service) continue;
            arrayList.add(connection);
        }
        return arrayList;
    }

    public void debug() {
        List list = this.getConnectionList(null);
        this.logger.log(8, "Connection count " + list.size());
        for (Connection connection : list) {
            this.logger.log(8, "Connection " + connection);
            connection.debug("\t");
        }
    }

    public void broadcastGoodbye(int n, String string) {
        List list = this.getConnectionList(null);
        for (int i = list.size() - 1; i >= 0; --i) {
            Connection connection = (Connection)list.get(i);
            connection.sayGoodbye(n, string);
        }
    }

    public void flushControlMessages(long l) {
        List list = this.getConnectionList(null);
        for (int i = list.size() - 1; i >= 0; --i) {
            Connection connection = (Connection)list.get(i);
            connection.flushConnection(l);
        }
    }

    public void checkAllConnections() {
        List list = this.getConnectionList(null);
        for (int i = list.size() - 1; i >= 0; --i) {
            Connection connection = (Connection)list.get(i);
            long l = connection.getAccessTime();
            if (this.lastConCheck == 0L || l == 0L || l >= this.lastConCheck) continue;
            connection.checkConnection();
        }
        this.lastConCheck = System.currentTimeMillis();
    }

    public void cleanupMemory(boolean bl) {
        if (bl) {
            this.logger.log(4, "Swapping all unacknowldged messages from memory (messages will remain persisted )");
        } else {
            this.logger.log(4, "Swapping all unacknowldged messages from memory (messages will be swapped to disk)");
        }
    }

    class ConnectionWatcher
    extends TimerTask {
        ConnectionWatcher() {
        }

        public void run() {
            ConnectionManager.this.checkAllConnections();
        }
    }
}

