/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyWaiter;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ReplyTracker {
    private Map waiters = Collections.synchronizedMap(new LinkedHashMap());

    public Long addWaiter(ReplyWaiter replyWaiter) {
        Long l = new Long(UniqueID.generateID((short)UID.getPrefix()));
        this.waiters.put(l, replyWaiter);
        return l;
    }

    public void addWaiter(Long l, ReplyWaiter replyWaiter) {
        this.waiters.put(l, replyWaiter);
    }

    public void removeWaiter(Long l) {
        this.waiters.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyStatus waitForReply(Long l, int n) throws BrokerException {
        ReplyStatus replyStatus;
        ReplyWaiter replyWaiter = (ReplyWaiter)this.waiters.get(l);
        assert (replyWaiter != null);
        try {
            replyStatus = replyWaiter.waitForReply(n);
            Object var6_5 = null;
            this.waiters.remove(l);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.waiters.remove(l);
            throw throwable;
        }
        return replyStatus;
    }

    public boolean notifyReply(Long l, BrokerAddress brokerAddress, GPacket gPacket) {
        ReplyWaiter replyWaiter = (ReplyWaiter)this.waiters.get(l);
        if (replyWaiter == null) {
            return false;
        }
        replyWaiter.notifyReply(brokerAddress, gPacket);
        return true;
    }

    public void abortWaiter(Long l) {
        ReplyWaiter replyWaiter = (ReplyWaiter)this.waiters.get(l);
        if (replyWaiter == null) {
            return;
        }
        replyWaiter.abort();
    }

    public void addBroker(BrokerAddress brokerAddress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBroker(BrokerAddress brokerAddress, boolean bl, boolean bl2) {
        Long l2 = null;
        ReplyWaiter replyWaiter = null;
        Set set = this.waiters.keySet();
        Map map = this.waiters;
        synchronized (map) {
            for (Long l2 : set) {
                replyWaiter = (ReplyWaiter)this.waiters.get(l2);
                replyWaiter.removeParticipant(brokerAddress, bl, bl2);
            }
        }
    }
}

