/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.heartbeat;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.Heartbeat;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.HeartbeatCallback;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.MQThreadGroup;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class HeartbeatImpl
implements Heartbeat {
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 2;
    public static final int DEFAULT_TIMEOUT_THRESHOLD = 3;
    private int heartbeatInterval = 2;
    private int timeoutThreshold = 3 * this.heartbeatInterval;
    private HeartbeatCallback cb = null;
    private InetSocketAddress bindEndpoint = null;
    private MQThreadGroup threadGroup = null;
    private Sender sender = null;
    private Receiver receiver = null;
    private boolean started = false;
    private Map endpoints = Collections.synchronizedMap(new LinkedHashMap());

    public String getName() {
        return null;
    }

    public String getProtocol() {
        return "udp";
    }

    public void init(InetSocketAddress inetSocketAddress, HeartbeatCallback heartbeatCallback) throws IOException {
        this.threadGroup = new MQThreadGroup("Heartbeat");
        this.bindEndpoint = inetSocketAddress;
        this.cb = heartbeatCallback;
        this.receiver = new Receiver();
        this.sender = new Sender();
        this.started = false;
    }

    public synchronized void stop() throws IOException {
        this.sender.close();
        this.receiver.close();
    }

    public synchronized void addEndpoint(Object object, InetSocketAddress inetSocketAddress, int n) throws IOException {
        this.endpoints.put(object, inetSocketAddress);
        try {
            this.sender.add(inetSocketAddress);
        }
        catch (SocketException socketException) {
            this.endpoints.remove(inetSocketAddress);
            throw socketException;
        }
        this.receiver.add(inetSocketAddress, n);
        if (!this.started) {
            this.receiver.start();
            this.sender.start();
            this.started = true;
        }
    }

    public synchronized void removeEndpoint(Object object, InetSocketAddress inetSocketAddress) throws IOException {
        this.endpoints.remove(object);
        if (!this.endpoints.containsValue(inetSocketAddress)) {
            this.sender.remove(inetSocketAddress);
        }
    }

    public InetSocketAddress getBindEndpoint() {
        return this.bindEndpoint;
    }

    public void setHeartbeatInterval(int n) {
        this.heartbeatInterval = n;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setTimeoutThreshold(int n) {
        this.timeoutThreshold = n;
    }

    public int getTimeoutThreshold() {
        return this.timeoutThreshold;
    }

    class Sender
    extends Thread {
        Map dss;
        DatagramPacket dp;
        boolean closed;

        Sender() throws IOException {
            super((ThreadGroup)HeartbeatImpl.this.threadGroup, "Heartbeat Sender");
            this.dss = Collections.synchronizedMap(new LinkedHashMap());
            this.dp = null;
            this.closed = false;
            this.setPriority(10);
            this.setDaemon(true);
            byte[] byArray = new byte[1];
            this.dp = new DatagramPacket(byArray, byArray.length);
        }

        void add(InetSocketAddress inetSocketAddress) throws SocketException {
            if (this.closed) {
                HeartbeatImpl.this.logger.log(4, "Heartbeat.Sender.addEnpoint: closed, ignore");
                return;
            }
            DatagramSocket datagramSocket = new DatagramSocket(0, HeartbeatImpl.this.bindEndpoint.getAddress());
            datagramSocket.connect(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            this.dss.put(inetSocketAddress, datagramSocket);
        }

        void remove(InetSocketAddress inetSocketAddress) {
            DatagramSocket datagramSocket = (DatagramSocket)this.dss.remove(inetSocketAddress);
            if (datagramSocket != null) {
                datagramSocket.disconnect();
                datagramSocket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            BrokerResources brokerResources = HeartbeatImpl.this.br;
            HeartbeatImpl.this.br;
            String string = brokerResources.getKString("B0074", super.getName());
            try {
                while (!this.closed) {
                    try {
                        Set set = HeartbeatImpl.this.endpoints.keySet();
                        Object[] objectArray = set.toArray(new Object[0]);
                        for (int i = 0; i < objectArray.length && !this.closed; ++i) {
                            try {
                                InetSocketAddress inetSocketAddress = (InetSocketAddress)HeartbeatImpl.this.endpoints.get(objectArray[i]);
                                byte[] byArray = HeartbeatImpl.this.cb.getBytesToSend(objectArray[i], inetSocketAddress);
                                if (byArray == null) {
                                    HeartbeatImpl.this.logger.log(16, "Heartbeat.Sender: no data send to " + inetSocketAddress + " for " + objectArray[i]);
                                    continue;
                                }
                                this.dp.setSocketAddress(inetSocketAddress);
                                this.dp.setData(byArray);
                                DatagramSocket datagramSocket = (DatagramSocket)this.dss.get(inetSocketAddress);
                                if (datagramSocket == null) {
                                    HeartbeatImpl.this.logger.log(4, "Heartbeat.Sender: Endpoint " + inetSocketAddress + " for " + objectArray[i] + " removed. no send");
                                    continue;
                                }
                                if (datagramSocket.isClosed() && !this.closed) {
                                    HeartbeatImpl.this.logger.log(4, "Heartbeat.Sender: Endoint " + inetSocketAddress + " for " + objectArray[i] + " removed. no send");
                                    datagramSocket = new DatagramSocket(0, HeartbeatImpl.this.bindEndpoint.getAddress());
                                    datagramSocket.connect(inetSocketAddress);
                                }
                                if (!datagramSocket.isConnected() && !this.closed) {
                                    datagramSocket.connect(inetSocketAddress);
                                }
                                if (this.closed) continue;
                                try {
                                    datagramSocket.send(this.dp);
                                }
                                catch (IOException iOException) {
                                    HeartbeatImpl.this.cb.heartbeatIOException(objectArray[i], inetSocketAddress, iOException);
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                HeartbeatImpl.this.logger.logStack(16, exception.getMessage(), (Throwable)exception);
                            }
                        }
                        if (this.closed) continue;
                        try {
                            Thread.sleep((long)HeartbeatImpl.this.heartbeatInterval * 1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable throwable) {
                        Logger logger = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger;
                        logger.logStack(16, super.getName() + ": " + throwable.getMessage(), throwable);
                    }
                }
                return;
            }
            finally {
                if (!this.closed) {
                    Logger logger = HeartbeatImpl.this.logger;
                    HeartbeatImpl.this.logger;
                    logger.log(16, string);
                }
            }
        }

        void close() {
            this.closed = true;
            this.interrupt();
            Set set = this.dss.keySet();
            InetSocketAddress[] inetSocketAddressArray = set.toArray(new InetSocketAddress[0]);
            for (int i = 0; i < inetSocketAddressArray.length; ++i) {
                this.remove(inetSocketAddressArray[i]);
            }
        }
    }

    class Receiver
    extends Thread {
        DatagramSocket ds;
        DatagramPacket dp;
        boolean refreshSize;
        boolean closed;
        int bufSize;
        Vector senderAddrs;

        Receiver() throws IOException {
            super((ThreadGroup)HeartbeatImpl.this.threadGroup, "Heartbeat Receiver");
            this.ds = null;
            this.dp = null;
            this.refreshSize = false;
            this.closed = false;
            this.bufSize = 0;
            this.senderAddrs = new Vector();
            this.setPriority(10);
            this.setDaemon(true);
            this.ds = new DatagramSocket(HeartbeatImpl.this.bindEndpoint);
            Logger logger = HeartbeatImpl.this.logger;
            BrokerResources brokerResources = HeartbeatImpl.this.br;
            HeartbeatImpl.this.br;
            logger.log(8, brokerResources.getKString("B1187", HeartbeatImpl.this.bindEndpoint.getAddress() + ":" + HeartbeatImpl.this.bindEndpoint.getPort()));
        }

        void add(InetSocketAddress inetSocketAddress, int n) {
            if (n > this.bufSize) {
                this.bufSize = n;
                this.refreshSize = true;
            }
            this.senderAddrs.add(inetSocketAddress.getAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            BrokerResources brokerResources = HeartbeatImpl.this.br;
            HeartbeatImpl.this.br;
            String string = brokerResources.getKString("B0074", super.getName());
            try {
                while (!this.closed) {
                    try {
                        Object object;
                        if ((this.ds == null || this.ds.isClosed()) && !this.closed) {
                            this.ds = new DatagramSocket(HeartbeatImpl.this.bindEndpoint);
                        }
                        if (this.closed) {
                            this.ds.close();
                            continue;
                        }
                        if (this.dp == null || this.refreshSize) {
                            object = new byte[this.bufSize];
                            if (this.dp == null) {
                                this.dp = new DatagramPacket((byte[])object, ((byte[])object).length);
                            }
                            this.dp.setData((byte[])object);
                        }
                        Logger logger = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger;
                        logger.log(1, "Heartbeat receiving ..");
                        this.ds.receive(this.dp);
                        Logger logger2 = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger;
                        logger2.log(1, "Heartbeat received heartbeat  from " + this.dp.getSocketAddress() + ":" + this.dp.getPort());
                        object = (InetSocketAddress)this.dp.getSocketAddress();
                        if (!this.senderAddrs.contains(((InetSocketAddress)object).getAddress())) {
                            Logger logger3 = HeartbeatImpl.this.logger;
                            HeartbeatImpl.this.logger;
                            BrokerResources brokerResources2 = HeartbeatImpl.this.br;
                            HeartbeatImpl.this.br;
                            logger3.log(16, brokerResources2.getKString("B2123", object));
                            continue;
                        }
                        try {
                            HeartbeatImpl.this.cb.heartbeatReceived((InetSocketAddress)object, this.dp.getData());
                        }
                        catch (IOException iOException) {
                            if (!DEBUG) continue;
                            Logger logger4 = HeartbeatImpl.this.logger;
                            HeartbeatImpl.this.logger;
                            logger4.log(8, iOException.getMessage() + " from " + this.dp.getSocketAddress() + ":" + this.dp.getPort() + ". Ignore");
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.closed) continue;
                        Logger logger = HeartbeatImpl.this.logger;
                        HeartbeatImpl.this.logger;
                        logger.logStack(16, super.getName() + ": " + throwable.getMessage(), throwable);
                    }
                }
                return;
            }
            finally {
                if (this.ds != null) {
                    this.ds.close();
                }
                if (!this.closed) {
                    Logger logger = HeartbeatImpl.this.logger;
                    HeartbeatImpl.this.logger;
                    logger.log(16, string);
                }
            }
        }

        void close() {
            this.closed = true;
            this.interrupt();
            if (this.ds != null) {
                this.ds.close();
            }
        }
    }
}

