/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.mbeans.resources.MBeanResources;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class MQMBeanReadOnly
extends NotificationBroadcasterSupport
implements DynamicMBean {
    int sequenceNumber = 0;
    protected Logger logger = Globals.getLogger();
    private String dClassName = this.getClass().getName();
    protected static final BrokerResources rb = Globals.getBrokerResources();
    protected static final MBeanResources mbr = Globals.getMBeanResources();
    private MBeanInfo dMBeanInfo = null;

    public MQMBeanReadOnly() {
        this.buildDynamicMBeanInfo();
    }

    public abstract String getMBeanName();

    public abstract String getMBeanDescription();

    public abstract MBeanAttributeInfo[] getMBeanAttributeInfo();

    public abstract MBeanOperationInfo[] getMBeanOperationInfo();

    public abstract MBeanNotificationInfo[] getMBeanNotificationInfo();

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String string = null;
        if (attribute != null) {
            string = attribute.getName();
        }
        throw new AttributeNotFoundException("Attribute " + string + " cannot be set in MBean: " + this.getMBeanName());
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null attribute list passed to setAttributes()"));
        }
        AttributeList attributeList2 = new AttributeList();
        if (attributeList.isEmpty()) {
            return attributeList2;
        }
        for (Attribute attribute : attributeList) {
            Object object;
            try {
                this.setAttribute(attribute);
                String string = attribute.getName();
                object = this.getAttribute(string);
                attributeList2.add(new Attribute(string, object));
            }
            catch (Exception exception) {
                object = "MBean " + this.getMBeanName() + ": Problem encountered while setting attribute " + attribute.getName() + ": " + exception.toString();
                this.logger.log(16, (String)object, (Throwable)exception);
            }
        }
        return attributeList2;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Object object;
        block8: {
            if (string == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Null Operation name passed to invoke()"));
            }
            MBeanOperationInfo mBeanOperationInfo = this.getOperationInfo(string, stringArray);
            Method method = null;
            object = null;
            if (mBeanOperationInfo == null) {
                method = this.getIsIsMethod(string);
                if (method == null) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Invalid operation name and/or signature passed to invoke(): " + string));
                }
            } else {
                method = this.getMethod(mBeanOperationInfo);
            }
            try {
                if (method == null) break block8;
                final Method method2 = method;
                final Object[] objectArray2 = objectArray;
                final MQMBeanReadOnly mQMBeanReadOnly = this;
                try {
                    object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            return method2.invoke((Object)mQMBeanReadOnly, objectArray2);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (Exception exception) {
                throw new MBeanException(exception, "Exception caught while invoking operation " + string + " in MBean " + this.getMBeanName());
            }
        }
        return object;
    }

    private Method getMethod(MBeanOperationInfo mBeanOperationInfo) throws ReflectionException {
        Method method = null;
        String string = null;
        if (mBeanOperationInfo == null) {
            return null;
        }
        try {
            Class[] classArray = null;
            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
            string = mBeanOperationInfo.getName();
            if (mBeanParameterInfoArray != null && mBeanParameterInfoArray.length > 0) {
                classArray = new Class[mBeanParameterInfoArray.length];
                for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
                    String string2 = mBeanParameterInfoArray[i].getType();
                    try {
                        Class<?> clazz;
                        classArray[i] = clazz = Class.forName(string2);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new ReflectionException(classNotFoundException, "Parameter type/class not found for operation" + string + " in MBean " + this.getMBeanName());
                    }
                }
            }
            method = this.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException, "Operation " + string + " does not exist in MBean" + this.getMBeanName());
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        return method;
    }

    private Method getIsIsMethod(String string) throws ReflectionException {
        Method method = null;
        String string2 = null;
        if (string == null) {
            return null;
        }
        String string3 = string.substring(2);
        try {
            this.checkIsIsAttribute(string3);
        }
        catch (Exception exception) {
            return null;
        }
        string2 = string;
        try {
            method = this.getClass().getMethod(string2, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException, "Operation " + string2 + " does not exist in MBean" + this.getMBeanName());
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        return method;
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Null attribute list passed to getAttributes()"));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                String string = "MBean " + this.getMBeanName() + ": Problem encountered while getting attribute " + stringArray[i] + ": " + exception.toString();
                this.logger.log(16, string, (Throwable)exception);
            }
        }
        return attributeList;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object[] objectArray;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Null attribute passed to getAttribute()"));
        }
        this.checkReadableAttribute(string);
        Method method = null;
        String string2 = "get" + string;
        Object object = null;
        try {
            objectArray = null;
            method = this.getClass().getMethod(string2, (Class<?>[])objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string3 = "MBean " + this.getMBeanName() + ": Cannot find method " + string2;
            throw new ReflectionException(noSuchMethodException, string3);
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        try {
            objectArray = null;
            object = method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
        return object;
    }

    private void checkReadableAttribute(String string) throws AttributeNotFoundException {
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttributeInfo(string);
        if (mBeanAttributeInfo == null) {
            throw new AttributeNotFoundException("The attribute " + string + " is not a valid attribute for MBean" + this.getMBeanName());
        }
        if (!mBeanAttributeInfo.isReadable()) {
            throw new AttributeNotFoundException("The attribute " + string + " is not a gettable attribute for MBean" + this.getMBeanName());
        }
    }

    private void checkIsIsAttribute(String string) throws AttributeNotFoundException {
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttributeInfo(string);
        if (mBeanAttributeInfo == null) {
            throw new AttributeNotFoundException("The attribute " + string + " is not a valid attribute for MBean" + this.getMBeanName());
        }
        if (!mBeanAttributeInfo.isIs()) {
            throw new AttributeNotFoundException("The attribute " + string + " is not an isIs attribute for MBean" + this.getMBeanName());
        }
    }

    public MBeanAttributeInfo getAttributeInfo(String string) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.getMBeanAttributeInfo();
        if (mBeanAttributeInfoArray == null) {
            return null;
        }
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[i];
            if (!mBeanAttributeInfo.getName().equals(string)) continue;
            return mBeanAttributeInfo;
        }
        return null;
    }

    public MBeanOperationInfo getOperationInfo(String string, String[] stringArray) {
        MBeanOperationInfo[] mBeanOperationInfoArray = this.getMBeanOperationInfo();
        if (mBeanOperationInfoArray == null) {
            return null;
        }
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            MBeanOperationInfo mBeanOperationInfo = mBeanOperationInfoArray[i];
            if (!mBeanOperationInfo.getName().equals(string) || !this.operationSignatureOK(mBeanOperationInfo, stringArray)) continue;
            return mBeanOperationInfo;
        }
        return null;
    }

    private boolean operationSignatureOK(MBeanOperationInfo mBeanOperationInfo, String[] stringArray) {
        if (mBeanOperationInfo == null) {
            return false;
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
        if (mBeanParameterInfoArray == null) {
            return stringArray == null;
        }
        if (stringArray == null) {
            return false;
        }
        if (mBeanParameterInfoArray.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            String string = mBeanParameterInfoArray[i].getType();
            if (stringArray[i] == null) {
                return false;
            }
            if (stringArray[i].equals(string)) continue;
            return false;
        }
        return true;
    }

    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    public MBeanConstructorInfo[] getMBeanConstructorInfo() {
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[]{new MBeanConstructorInfo("Constructor", constructorArray[0])};
        return mBeanConstructorInfoArray;
    }

    protected void handleGetterException(String string, Throwable throwable) throws MBeanException {
        String string2 = this.getMBeanName() + ": Problem encountered while getting attribute " + string + ": " + throwable.toString();
        this.logger.log(16, string2, throwable);
        throw new MBeanException(new Exception(string2));
    }

    protected void handleSetterException(String string, Throwable throwable) throws MBeanException {
        String string2 = this.getMBeanName() + ": Problem encountered while setting attribute " + string + ": " + throwable.toString();
        this.logger.log(16, string2, throwable);
        throw new MBeanException(new Exception(string2));
    }

    protected void handleOperationException(String string, Exception exception) throws MBeanException {
        String string2 = "MBean " + this.getMBeanName() + ": Problem encountered while invoking operation " + string + ": " + exception.toString();
        this.logger.log(16, string2);
        throw new MBeanException(new Exception(string2));
    }

    private void buildDynamicMBeanInfo() {
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.getMBeanDescription(), this.getMBeanAttributeInfo(), this.getMBeanConstructorInfo(), this.getMBeanOperationInfo(), this.getMBeanNotificationInfo());
    }
}

