/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Hashtable;

public class UpdateServiceHandler
extends AdminCmdHandler {
    private static boolean DEBUG = UpdateServiceHandler.getDEBUG();

    public UpdateServiceHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + hashtable);
        }
        ServiceInfo serviceInfo = (ServiceInfo)this.getBodyObject(packet);
        int n = 200;
        String string = null;
        ServiceManager serviceManager = Globals.getServiceManager();
        Service service = null;
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n = 500;
            string = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string);
        } else if (serviceInfo.name == null || (service = serviceManager.getService(serviceInfo.name)) == null) {
            n = 500;
            string = this.rb.getString("B4057", serviceInfo.name == null ? "<null>" : serviceInfo.name);
        }
        if (n == 200) {
            if (!(service instanceof IMQService)) {
                n = 500;
                string = "Internal Error: can updated non-standard Service";
            } else {
                try {
                    object = (IMQService)service;
                    int n2 = -1;
                    int n3 = -1;
                    int n4 = -1;
                    if (serviceInfo.isModified(1)) {
                        n2 = serviceInfo.port;
                    }
                    if (serviceInfo.isModified(2)) {
                        n3 = serviceInfo.minThreads;
                    }
                    if (serviceInfo.isModified(4)) {
                        n4 = serviceInfo.maxThreads;
                    }
                    if (n2 != -1 || n3 != -1 || n4 != -1) {
                        ((IMQService)object).updateService(n2, n3, n4);
                    } else {
                        n = 500;
                        string = this.rb.getString("B4085", serviceInfo.name);
                    }
                }
                catch (Exception exception) {
                    this.logger.log(16, "B2047", (Object)service.getName(), (Throwable)exception);
                    n = 500;
                    string = UpdateServiceHandler.getMessageFromException(exception);
                }
            }
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        object.setPacketType(5);
        UpdateServiceHandler.setProperties((Packet)object, 47, n, string);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }
}

