/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;

class LoaderConfigContent {
    private static final String OSGI_CONFIG_FILE_PATH = "osgi/felix/conf/config.properties";
    private final String content;

    LoaderConfigContent(File installDir) throws FileNotFoundException, IOException {
        this.content = this.loadContent(this.configFileURI(installDir));
    }

    String content() {
        return this.content;
    }

    private String loadContent(URI configFileURI) throws FileNotFoundException, IOException {
        int charsRead;
        File configFile = new File(configFileURI);
        FileReader fr = new FileReader(configFile);
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        while ((charsRead = fr.read(buffer)) != -1) {
            sb.append(buffer, 0, charsRead);
        }
        fr.close();
        return sb.toString();
    }

    private URI configFileURI(File installDir) {
        return installDir.toURI().resolve(OSGI_CONFIG_FILE_PATH);
    }
}

