/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CombinedXPath {
    private static final String OWNED_PROPERTY_NAME = "owned";
    private static final String DEFAULTED_PROPERTY_NAME = "defaulted";
    private static final String MERGED_PROPERTY_NAME = "merged";
    private static final XPathFactory xPathFactory = XPathFactory.newInstance();
    private static final XPath xPath = xPathFactory.newXPath();
    private final XPathExpression targetExpr;
    private final XPathExpression parentExpr;

    static List<CombinedXPath> parse(Properties p) {
        ArrayList<CombinedXPath> result = new ArrayList<CombinedXPath>();
        result.addAll(CombinedXPath.parse(p, Type.OWNED));
        result.addAll(CombinedXPath.parse(p, Type.DEFAULTED));
        result.addAll(CombinedXPath.parse(p, Type.MERGED));
        return result;
    }

    private static List<CombinedXPath> parse(Properties p, Type type) {
        ArrayList<CombinedXPath> result = new ArrayList<CombinedXPath>();
        String refs = p.getProperty(type.propertyName);
        block5: for (String ref : refs.split(",")) {
            String[] paths = ref.split(":");
            if (paths.length != 2) {
                throw new IllegalArgumentException(ref);
            }
            switch (type) {
                case OWNED: {
                    result.add(new OwnedXPath(xPath, paths[0], paths[1]));
                    continue block5;
                }
                case MERGED: {
                    result.add(new MergedXPath(xPath, paths[0], paths[1]));
                    continue block5;
                }
                case DEFAULTED: {
                    result.add(new DefaultedXPath(xPath, paths[0], paths[1]));
                }
            }
        }
        return result;
    }

    CombinedXPath(XPath xPath, String parentPath, String targetRelativePath) {
        try {
            this.parentExpr = xPath.compile(parentPath);
            this.targetExpr = xPath.compile(parentPath + targetRelativePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    XPathExpression targetExpr() {
        return this.targetExpr;
    }

    XPathExpression parentExpr() {
        return this.parentExpr;
    }

    abstract void process(Document var1, Document var2) throws XPathExpressionException;

    protected void insert(Document originalDOM, Node insertionPoint, Node newNode) throws XPathExpressionException {
        if (newNode instanceof Attr) {
            this.setAttr(originalDOM, insertionPoint, (Attr)newNode);
        } else {
            this.insertNode(originalDOM, insertionPoint, newNode);
        }
    }

    private void setAttr(Document originalDOM, Node insertionPoint, Attr newAttr) throws XPathExpressionException {
        Element parent = insertionPoint == null ? (Element)this.parentExpr().evaluate(originalDOM, XPathConstants.NODE) : ((Attr)insertionPoint).getOwnerElement();
        parent.setAttribute(newAttr.getName(), newAttr.getValue());
    }

    private void insertNode(Document originalDOM, Node insertionPoint, Node newNode) throws XPathExpressionException {
        Node parentNode = insertionPoint == null ? (Node)this.parentExpr().evaluate(originalDOM, XPathConstants.NODE) : insertionPoint.getParentNode();
        parentNode.insertBefore(originalDOM.adoptNode(newNode), insertionPoint);
    }

    static class DefaultedXPath
    extends CombinedXPath {
        DefaultedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            NodeList developerNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            if (developerNodes.getLength() > 0) {
                return;
            }
            NodeList generatedNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            Node developerParent = (Node)this.parentExpr().evaluate(developerDOM, XPathConstants.NODE);
            for (int i = 0; i < generatedNodes.getLength(); ++i) {
                this.append(developerParent, developerDOM.adoptNode(generatedNodes.item(i)));
            }
        }

        private void append(Node parent, Node newNode) {
            if (newNode instanceof Attr) {
                ((Element)parent).setAttributeNode((Attr)newNode);
            } else {
                parent.appendChild(parent.getOwnerDocument().importNode(newNode, true));
            }
        }
    }

    static class MergedXPath
    extends CombinedXPath {
        MergedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            NodeList developerNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            NodeList generatedNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            Node insertionPoint = developerNodes.getLength() > 0 ? developerNodes.item(0) : null;
            for (int i = 0; i < generatedNodes.getLength(); ++i) {
                this.insert(developerDOM, insertionPoint, generatedNodes.item(i));
            }
        }
    }

    static class OwnedXPath
    extends CombinedXPath {
        OwnedXPath(XPath xPath, String parentPath, String targetRelativePath) {
            super(xPath, parentPath, targetRelativePath);
        }

        void process(Document developerDOM, Document generatedDOM) throws XPathExpressionException {
            int i;
            NodeList originalNodes = (NodeList)this.targetExpr().evaluate(developerDOM, XPathConstants.NODESET);
            NodeList replacementNodes = (NodeList)this.targetExpr().evaluate(generatedDOM, XPathConstants.NODESET);
            Node insertionPoint = originalNodes.getLength() > 0 ? originalNodes.item(0).getPreviousSibling() : null;
            for (i = 0; i < originalNodes.getLength(); ++i) {
                this.remove(originalNodes.item(i));
            }
            for (i = 0; i < replacementNodes.getLength(); ++i) {
                this.insert(developerDOM, insertionPoint, replacementNodes.item(i));
            }
        }

        private void remove(Node originalNode) {
            if (originalNode instanceof Attr) {
                this.removeAttr((Attr)originalNode);
            } else {
                this.removeNode(originalNode);
            }
        }

        private void removeNode(Node originalNode) {
            originalNode.getParentNode().removeChild(originalNode);
        }

        private void removeAttr(Attr originalAttr) {
            Element parent = originalAttr.getOwnerElement();
            parent.removeAttribute(originalAttr.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        OWNED("owned"),
        DEFAULTED("defaulted"),
        MERGED("merged");

        private String propertyName;

        private Type(String propName) {
            this.propertyName = propName;
        }
    }
}

