/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.ClassFile;
import com.sun.enterprise.deployment.annotation.introspection.ConstantPoolInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import org.glassfish.api.deployment.archive.ReadableArchive;

public class AnnotationDetector {
    protected final ClassFile classFile;

    public AnnotationDetector(AnnotationScanner scanner) {
        ConstantPoolInfo poolInfo = new ConstantPoolInfo(scanner);
        this.classFile = new ClassFile(poolInfo);
    }

    public boolean hasAnnotationInArchive(ReadableArchive archive) throws IOException {
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (!entryName.endsWith(".class") || !this.containsAnnotation(archive, entryName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnnotation(ReadableArchive archive, String entryName) throws IOException {
        return this.containsAnnotation(archive.getEntry(entryName), archive.getEntrySize(entryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAnnotation(InputStream is, long size) throws IOException {
        boolean result = false;
        ReadableByteChannel channel = null;
        try {
            channel = Channels.newChannel(is);
            if (channel != null) {
                result = this.classFile.containsAnnotation(channel, size);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }
}

