/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.ServletMappingNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.URLPattern;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.DispatcherType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterMappingNode
extends DeploymentDescriptorNode {
    private ServletFilterMappingDescriptor descriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServletMappingNode.class);

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ServletFilterMappingDescriptor)super.getDescriptor();
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("filter-name", "setName");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("servlet-name".equals(element.getQName())) {
            this.descriptor.addServletName(value);
        } else if ("url-pattern".equals(element.getQName())) {
            if (!URLPattern.isValid((String)value)) {
                String trimmedUrl = value.trim();
                Object parent = this.getParentNode().getDescriptor();
                if (parent instanceof WebBundleDescriptor && ((WebBundleDescriptor)parent).getSpecVersion().equals("2.2") && !trimmedUrl.startsWith("/") && !trimmedUrl.startsWith("*.")) {
                    trimmedUrl = "/" + trimmedUrl;
                }
                if (URLPattern.isValid((String)trimmedUrl)) {
                    if (URLPattern.containsCRorLF((String)value)) {
                        DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.urlcontainscrlf", new Object[]{value});
                    }
                    value = trimmedUrl;
                } else {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.invalidurlpattern", "Invalid URL Pattern: [{0}]", new Object[]{value}));
                }
            }
            this.descriptor.addURLPattern(value);
        } else if ("dispatcher".equals(element.getQName())) {
            this.descriptor.addDispatcher(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ServletFilterMappingDescriptor descriptor) {
        Element myNode = FilterMappingNode.appendChild(parent, nodeName);
        FilterMappingNode.appendTextChild((Node)myNode, "filter-name", descriptor.getName());
        for (String servletName : descriptor.getServletNames()) {
            FilterMappingNode.appendTextChild((Node)myNode, "servlet-name", servletName);
        }
        for (String urlPattern : descriptor.getURLPatterns()) {
            FilterMappingNode.appendTextChild((Node)myNode, "url-pattern", urlPattern);
        }
        for (DispatcherType dispatcherType : descriptor.getDispatchers()) {
            FilterMappingNode.appendTextChild((Node)myNode, "dispatcher", dispatcherType.name());
        }
        return myNode;
    }
}

