/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.connector.AdminObjectNode;
import com.sun.enterprise.deployment.node.connector.ConfigPropertyNode;
import com.sun.enterprise.deployment.node.connector.InBoundRANode;
import com.sun.enterprise.deployment.node.connector.OutBoundRANode;
import com.sun.enterprise.deployment.node.connector.SecurityPermissionNode;
import java.util.Map;
import org.w3c.dom.Node;

public final class RANode
extends DeploymentDescriptorNode {
    private ConnectorDescriptor descriptor = null;
    public static final String VERSION_10 = "1.0";
    public static final String VERSION_15 = "1.5";

    public RANode() {
        this.register();
    }

    public RANode(XMLElement element) {
        this.setXMLRootTag(element);
        this.register();
    }

    private void register() {
        this.registerElementHandler(new XMLElement("outbound-resourceadapter"), OutBoundRANode.class);
        this.registerElementHandler(new XMLElement("inbound-resourceadapter"), InBoundRANode.class);
        this.registerElementHandler(new XMLElement("config-property"), ConfigPropertyNode.class, "addConfigProperty");
        this.registerElementHandler(new XMLElement("adminobject"), AdminObjectNode.class, "addAdminObject");
        this.registerElementHandler(new XMLElement("security-permission"), SecurityPermissionNode.class, "addSecurityPermission");
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ConnectorDescriptor)this.getParentNode().getDescriptor();
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("resourceadapter-class", "setResourceAdapterClass");
        return table;
    }

    public Node writeDescriptor(Node connectorNode, Descriptor descriptor) {
        if (!(descriptor instanceof ConnectorDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handle descriptors of type " + descriptor.getClass());
        }
        ConnectorDescriptor conDesc = (ConnectorDescriptor)descriptor;
        Node raNode = RANode.appendChild(connectorNode, "resourceadapter");
        RANode.appendTextChild(raNode, "resourceadapter-class", conDesc.getResourceAdapterClass());
        ConfigPropertyNode config = new ConfigPropertyNode();
        raNode = config.writeDescriptor(raNode, conDesc);
        if (conDesc.getOutBoundDefined()) {
            OutBoundRANode obNode = new OutBoundRANode();
            raNode = obNode.writeDescriptor(raNode, conDesc);
        }
        if (conDesc.getInBoundDefined()) {
            InBoundRANode inNode = new InBoundRANode();
            raNode = inNode.writeDescriptor(raNode, conDesc);
        }
        AdminObjectNode admin = new AdminObjectNode();
        raNode = admin.writeDescriptor(raNode, conDesc);
        SecurityPermissionNode secPerm = new SecurityPermissionNode();
        raNode = secPerm.writeDescriptor(raNode, conDesc);
        return connectorNode;
    }
}

