/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.OrderingOrderingDescriptor;
import com.sun.enterprise.deployment.WebFragmentDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingDescriptor
extends Descriptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(OrderingDescriptor.class);
    OrderingOrderingDescriptor after = null;
    OrderingOrderingDescriptor before = null;

    public OrderingOrderingDescriptor getAfter() {
        return this.after;
    }

    public void setAfter(OrderingOrderingDescriptor after) {
        this.after = after;
        this.validate();
    }

    public OrderingOrderingDescriptor getBefore() {
        return this.before;
    }

    public void setBefore(OrderingOrderingDescriptor before) {
        this.before = before;
        this.validate();
    }

    public void validate() {
        boolean valid = true;
        if (this.after != null && this.before != null) {
            if (this.after.containsOthers() && this.before.containsOthers()) {
                valid = false;
            }
            if (valid) {
                for (String name : this.after.getNames()) {
                    if (!this.before.containsName(name)) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (!valid) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioninvalidordering", "The ordering is not valid as it contains the same name and/or others in both before and after."));
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.after != null) {
            builder.append("after: " + this.after + ", ");
        }
        if (this.before != null) {
            builder.append("before: " + this.before);
        }
        return builder.toString();
    }

    public static void sort(List<WebFragmentDescriptor> wfs) {
        if (wfs == null || wfs.size() <= 1) {
            return;
        }
        ArrayList<Node> graph = new ArrayList<Node>();
        HashMap<String, Node> name2NodeMap = new HashMap<String, Node>();
        Node othersNode = new Node(null);
        for (WebFragmentDescriptor wf : wfs) {
            Node wfNode = new Node(wf);
            String wfName = wf.getName();
            if (wfName != null && wfName.length() > 0) {
                name2NodeMap.put(wfName, wfNode);
            }
            graph.add(wfNode);
        }
        ArrayList remaining = new ArrayList(graph);
        boolean hasOthers = false;
        for (int i = 0; i < graph.size(); ++i) {
            boolean hasBeforeOrdering;
            OrderingOrderingDescriptor before;
            Node wfNode = (Node)graph.get(i);
            WebFragmentDescriptor wf = wfNode.getWebFragmentDescriptor();
            String wfName = wf.getName();
            OrderingDescriptor od = wf.getOrderingDescriptor();
            if (od == null) continue;
            OrderingOrderingDescriptor after = od.getAfter();
            if (after != null) {
                if (after.containsOthers()) {
                    wfNode.getInNodes().add(othersNode);
                    othersNode.getOutNodes().add(wfNode);
                    remaining.remove(othersNode);
                    hasOthers = true;
                }
                for (String name : after.getNames()) {
                    Node nameNode = (Node)name2NodeMap.get(name);
                    wfNode.getInNodes().add(nameNode);
                    nameNode.getOutNodes().add(wfNode);
                    remaining.remove(nameNode);
                }
            }
            if ((before = od.getBefore()) != null) {
                if (before.containsOthers()) {
                    wfNode.getOutNodes().add(othersNode);
                    othersNode.getInNodes().add(wfNode);
                    remaining.remove(othersNode);
                    hasOthers = true;
                }
                for (String name : before.getNames()) {
                    Node nameNode = (Node)name2NodeMap.get(name);
                    wfNode.getOutNodes().add(nameNode);
                    nameNode.getInNodes().add(wfNode);
                    remaining.remove(nameNode);
                }
            }
            boolean hasAfterOrdering = after != null && (after.containsOthers() || after.getNames().size() > 0);
            boolean bl = hasBeforeOrdering = before != null && (before.containsOthers() || before.getNames().size() > 0);
            if (!hasAfterOrdering && !hasBeforeOrdering) continue;
            remaining.remove(wfNode);
        }
        if (hasOthers) {
            graph.add(othersNode);
        }
        ArrayList<Node> subgraph = new ArrayList<Node>(graph);
        subgraph.removeAll(remaining);
        boolean hasRemaining = remaining.size() > 0;
        List<Node> sortedNodes = OrderingDescriptor.topologicalSort(subgraph, hasRemaining);
        wfs.clear();
        boolean othersProcessed = false;
        for (Node node : sortedNodes) {
            WebFragmentDescriptor wf = node.getWebFragmentDescriptor();
            if (wf == null) {
                othersProcessed = true;
                for (Node rnode : remaining) {
                    wfs.add(rnode.getWebFragmentDescriptor());
                }
                continue;
            }
            wfs.add(wf);
        }
        if (!othersProcessed) {
            for (Node rnode : remaining) {
                wfs.add(rnode.getWebFragmentDescriptor());
            }
        }
    }

    private static List<Node> topologicalSort(List<Node> graph, boolean hasRemaining) {
        ArrayList<Node> sortedNodes = new ArrayList<Node>();
        if (graph.size() == 0) {
            return sortedNodes;
        }
        Stack<Node> roots = new Stack<Node>();
        for (Node node : graph) {
            if (node.getInNodes().size() != 0) continue;
            roots.push(node);
        }
        if (roots.empty()) {
            if (OrderingDescriptor.isCircleWithOthersAndNoRemaining(graph, hasRemaining, sortedNodes)) {
                return sortedNodes;
            }
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioninvalidwebfragmentordering", "The web fragment ordering is not valid and possibly has cycling conflicts."));
        }
        while (!roots.empty()) {
            Node node = (Node)roots.pop();
            sortedNodes.add(node);
            Iterator outNodesIter = node.getOutNodes().iterator();
            while (outNodesIter.hasNext()) {
                Node outNode = (Node)outNodesIter.next();
                outNodesIter.remove();
                outNode.getInNodes().remove(node);
                if (outNode.getInNodes().size() != 0) continue;
                roots.push(outNode);
            }
        }
        boolean hasEdges = false;
        for (Node node : graph) {
            if (node.getInNodes().size() <= 0 && node.getOutNodes().size() <= 0) continue;
            hasEdges = true;
            break;
        }
        if (hasEdges) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioninvalidwebfragmentordering", "The web fragment ordering is not valid and possibly has cycling conflicts."));
        }
        return sortedNodes;
    }

    private static boolean isCircleWithOthersAndNoRemaining(List<Node> graph, boolean hasRemaining, List<Node> sortedNodes) {
        boolean circleWithOthersAndNoRemaining = false;
        int size = graph.size();
        if (size == 0 || hasRemaining) {
            return circleWithOthersAndNoRemaining;
        }
        Node nextNode = graph.get(size - 1);
        if (nextNode.getWebFragmentDescriptor() == null) {
            LinkedHashSet<Node> set = new LinkedHashSet<Node>();
            for (int count = 0; count < size && nextNode.getOutNodes().size() == 1 && nextNode.getInNodes().size() == 1 && set.add(nextNode); ++count) {
                nextNode = (Node)nextNode.getOutNodes().iterator().next();
            }
            if (set.size() == size) {
                circleWithOthersAndNoRemaining = true;
                Iterator iter = set.iterator();
                if (iter.hasNext()) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    sortedNodes.add((Node)iter.next());
                }
            }
        }
        return circleWithOthersAndNoRemaining;
    }

    private static void print(WebFragmentDescriptor wf, String nullWfString, StringBuilder sb) {
        String wfName = null;
        wfName = wf != null ? wf.getName() : nullWfString;
        sb.append(wfName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        private WebFragmentDescriptor webFragmentDescriptor = null;
        private Set<Node> inNodes = new LinkedHashSet<Node>();
        private Set<Node> outNodes = new LinkedHashSet<Node>();

        private Node(WebFragmentDescriptor wf) {
            this.webFragmentDescriptor = wf;
        }

        private WebFragmentDescriptor getWebFragmentDescriptor() {
            return this.webFragmentDescriptor;
        }

        private Set<Node> getInNodes() {
            return this.inNodes;
        }

        private Set<Node> getOutNodes() {
            return this.outNodes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{name=");
            OrderingDescriptor.print(this.webFragmentDescriptor, "@others", sb);
            sb.append(", inNodes=[");
            boolean first = true;
            for (Node n : this.inNodes) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                OrderingDescriptor.print(n.getWebFragmentDescriptor(), "@others", sb);
            }
            sb.append("]");
            sb.append(", outNodes=[");
            first = true;
            for (Node n : this.outNodes) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                OrderingDescriptor.print(n.getWebFragmentDescriptor(), "@others", sb);
            }
            sb.append("]}");
            return sb.toString();
        }
    }
}

