/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.event.EncodeEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutComposition
extends LayoutElementBase {
    private static final long serialVersionUID = 2L;
    private static final String COMPOSITION_STACK_KEY = "_composition";
    private static final String GLOBAL_PARAM_MAP_KEY = "_uiparamCacheMap";
    private static Map _testMap = null;
    private Map<String, Object> _params = null;
    private String required = null;
    private String template = null;
    private boolean trimming = true;

    public LayoutComposition(LayoutElement parent, String id) {
        super(parent, id);
    }

    public LayoutComposition(LayoutElement parent, String id, boolean trimming) {
        super(parent, id);
        this.trimming = trimming;
    }

    public boolean isRequired() {
        Object answer;
        boolean result = true;
        if (this.required != null && (answer = this.resolveValue(FacesContext.getCurrentInstance(), null, this.required)) != null) {
            result = Boolean.parseBoolean(answer.toString());
        }
        return result;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    public String getTemplate() {
        Object result = this.resolveValue(FacesContext.getCurrentInstance(), null, this.template);
        return result == null ? null : result.toString();
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isTrimming() {
        return this.trimming;
    }

    public void setTrimming(boolean trimming) {
        this.trimming = trimming;
    }

    @Override
    protected boolean encodeThis(FacesContext context, UIComponent component) throws IOException {
        LayoutDefinition template;
        boolean result;
        block5: {
            String templateName = this.getTemplate();
            result = true;
            if (templateName == null) {
                return result;
            }
            LayoutComposition.push(context, this);
            this.dispatchHandlers(context, "encode", new EncodeEvent(component));
            template = null;
            try {
                template = LayoutDefinitionManager.getLayoutDefinition(context, templateName);
            }
            catch (LayoutDefinitionException ex) {
                if (!this.isRequired()) break block5;
                throw ex;
            }
        }
        if (template != null) {
            LayoutElement childElt2 = null;
            for (LayoutElement childElt2 : template.getChildLayoutElements()) {
                childElt2.encode(context, component);
            }
            result = false;
        }
        LayoutComposition.pop(context);
        return result;
    }

    public static void push(FacesContext context, LayoutElement comp) {
        Map<String, Object> params;
        if (comp instanceof LayoutComposition && (params = ((LayoutComposition)comp).getParameters()) != null) {
            Map<String, Object> globalParamMap = LayoutComposition.getGlobalParamMap(context);
            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
            Map.Entry<String, Object> entry = null;
            while (it.hasNext()) {
                entry = it.next();
                globalParamMap.put(entry.getKey(), entry.getValue());
            }
        }
        LayoutComposition.getCompositionStack(context).push(comp);
    }

    public static LayoutElement pop(FacesContext context) {
        return LayoutComposition.getCompositionStack(context).pop();
    }

    public static Stack<LayoutElement> getCompositionStack(FacesContext context) {
        Map requestMap = context == null ? LayoutComposition.getTestMap() : context.getExternalContext().getRequestMap();
        Stack stack = (Stack)requestMap.get(COMPOSITION_STACK_KEY);
        if (stack == null) {
            stack = new Stack();
            requestMap.put(COMPOSITION_STACK_KEY, stack);
        }
        return stack;
    }

    public static Map<String, Object> getGlobalParamMap(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap paramMap = (HashMap)requestMap.get(GLOBAL_PARAM_MAP_KEY);
        if (paramMap == null) {
            paramMap = new HashMap();
            requestMap.put(GLOBAL_PARAM_MAP_KEY, paramMap);
        }
        return paramMap;
    }

    private static Map<String, Object> getTestMap() {
        if (_testMap == null) {
            _testMap = new HashMap();
        }
        return _testMap;
    }

    public static Stack<LayoutElement> setCompositionStack(FacesContext context, Stack<LayoutElement> stack) {
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put(COMPOSITION_STACK_KEY, stack);
        return stack;
    }

    public static Object findTemplateParam(List<LayoutElement> eltList, String name) {
        Iterator<LayoutElement> stackIt = eltList.iterator();
        Object val = null;
        LayoutElement elt = null;
        LayoutComposition comp = null;
        while (stackIt.hasNext() && (!((elt = stackIt.next()) instanceof LayoutComposition) || (val = (comp = (LayoutComposition)elt).getParameter(name)) == null)) {
        }
        return val;
    }

    protected Map<String, Object> getParameters() {
        return this._params;
    }

    public Object getParameter(String name) {
        Object value = null;
        if (this._params != null) {
            value = this._params.get(name);
        }
        return value;
    }

    public void setParameter(String name, Object value) {
        if (this._params == null) {
            this._params = new HashMap<String, Object>();
        }
        this._params.put(name, value);
    }
}

