/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.factory.tree;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.ComponentFactoryBase;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptor;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class DynamicTreeNodeFactory
extends ComponentFactoryBase {
    public static final String TREE_ADAPTOR_CLASS = "treeAdaptorClass";

    public UIComponent create(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
        TreeAdaptor treeAdaptor = this.getTreeAdaptor(context, descriptor, parent);
        treeAdaptor.init();
        Object currentObj = treeAdaptor.getTreeNodeObject();
        return this.processNode(context, treeAdaptor, currentObj, parent);
    }

    protected TreeAdaptor getTreeAdaptor(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        TreeAdaptor adaptor = null;
        Object cls = desc.getEvaluatedOption(ctx, TREE_ADAPTOR_CLASS, parent);
        if (cls == null) {
            throw new IllegalArgumentException("'treeAdaptorClass' must be specified!");
        }
        try {
            Class adaptorClass = Util.getClass(cls);
            adaptor = (TreeAdaptor)adaptorClass.getMethod("getInstance", FacesContext.class, LayoutComponent.class, UIComponent.class).invoke((Object)null, ctx, desc, parent);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return adaptor;
    }

    protected UIComponent processNode(FacesContext ctx, TreeAdaptor adaptor, Object currentObj2, UIComponent parent) {
        String id = adaptor.getId(currentObj2);
        String factoryClass = adaptor.getFactoryClass(currentObj2);
        Map<String, Object> props = adaptor.getFactoryOptions(currentObj2);
        Properties properties = Util.mapToProperties(props);
        UIComponent node = ComponentUtil.getInstance(ctx).getChild(parent, id, factoryClass, properties);
        if (parent != null) {
            parent.getFacets().remove(id);
            parent.getChildren().add(node);
        }
        this.configureTreeNode(ctx, adaptor, node, currentObj2);
        List<Object> children = adaptor.getChildTreeNodeObjects(currentObj2);
        if (children != null) {
            for (Object currentObj2 : children) {
                this.processNode(ctx, adaptor, currentObj2, node);
            }
        }
        return node;
    }

    protected void configureTreeNode(FacesContext ctx, TreeAdaptor adaptor, UIComponent treeNode, Object currentObj) {
        Map<String, List<Handler>> handlersByType;
        Iterator<String> it;
        Map<String, UIComponent> facets = adaptor.getFacets(treeNode, currentObj);
        if (facets != null) {
            Map treeNodeFacets = treeNode.getFacets();
            it = facets.keySet().iterator();
            while (it.hasNext()) {
                String facetName = it.next();
                UIComponent facetValue = facets.get(facetName);
                if (facetValue == null) continue;
                treeNodeFacets.put(facetName, facetValue);
            }
        }
        if ((handlersByType = adaptor.getHandlersByType(treeNode, currentObj)) != null && (it = handlersByType.keySet().iterator()).hasNext()) {
            String eventType = null;
            Map compAttrs = treeNode.getAttributes();
            while (it.hasNext()) {
                eventType = it.next();
                compAttrs.put(eventType, handlersByType.get(eventType));
            }
        }
    }
}

