/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jar")
@Scoped(value=PerLookup.class)
public class InputJarArchive
extends JarArchive
implements ReadableArchive {
    static final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
    protected JarFile jarFile = null;
    protected JarInputStream jarIS = null;
    private URI uri;
    private InputJarArchive parentArchive = null;
    private StringManager localStrings = StringManager.getManager(this.getClass());

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.uri == null) {
            return -1L;
        }
        File tmpFile = new File(this.uri);
        return tmpFile.length();
    }

    public OutputStream addEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
            this.jarIS = null;
        }
    }

    public Collection<String> getDirectories() throws IOException {
        return new CollectionWrappedEnumeration<String>(new CollectionWrappedEnumeration.EnumerationFactory<String>(){

            @Override
            public Enumeration<String> enumeration() {
                return InputJarArchive.this.entries(true);
            }
        });
    }

    public void create(URI uri) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public Enumeration<String> entries() {
        return this.entries(false);
    }

    private Enumeration<String> entries(boolean directoriesOnly) {
        if (this.parentArchive != null) {
            try {
                return new SubarchiveEntryEnumeration(directoriesOnly);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            if (this.jarFile == null) {
                this.getJarFile(this.uri);
            }
        }
        catch (IOException ioe) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        if (this.jarFile == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return new TopLevelEntryEnumeration(directoriesOnly);
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    @Override
    public JarEntry getJarEntry(String name) {
        if (this.jarFile != null) {
            return this.jarFile.getJarEntry(name);
        }
        return null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        ZipEntry ze;
        return this.jarFile != null && (ze = this.jarFile.getEntry(name)) != null;
    }

    public InputStream getEntry(String entryName) throws IOException {
        if (this.jarFile != null) {
            ZipEntry ze = this.jarFile.getEntry(entryName);
            if (ze != null) {
                return new BufferedInputStream(this.jarFile.getInputStream(ze));
            }
            return null;
        }
        if (this.parentArchive != null && this.parentArchive.jarFile != null) {
            JarEntry je;
            JarEntry archiveJarEntry;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            JarEntry jarEntry = archiveJarEntry = this.uri != null ? this.parentArchive.jarFile.getJarEntry(this.uri.getSchemeSpecificPart()) : null;
            if (archiveJarEntry == null) {
                return null;
            }
            this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(archiveJarEntry));
            while ((je = this.jarIS.getNextJarEntry()) != null && !je.getName().equals(entryName)) {
            }
            if (je != null) {
                return new BufferedInputStream(this.jarIS);
            }
            return null;
        }
        return null;
    }

    public long getEntrySize(String name) {
        ZipEntry ze;
        if (this.jarFile != null && (ze = this.jarFile.getEntry(name)) != null) {
            return ze.getSize();
        }
        return 0L;
    }

    public void open(URI uri) throws IOException {
        this.uri = uri;
        this.jarFile = this.getJarFile(uri);
    }

    protected JarFile getJarFile(URI uri) throws IOException {
        if (!uri.getScheme().equals("jar")) {
            throw new IOException("Wrong scheme for InputJarArchive : " + uri.getScheme());
        }
        this.jarFile = null;
        try {
            File file = new File(uri.getSchemeSpecificPart());
            if (file.exists()) {
                this.jarFile = new JarFile(file);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "enterprise.deployment.backend.fileOpenFailure", new Object[]{uri});
            String additionalInfo = this.localStrings.getString("enterprise.deployment.invalid_zip_file", (Object)uri);
            logger.log(Level.WARNING, e.getLocalizedMessage() + " --  " + additionalInfo);
        }
        return this.jarFile;
    }

    public Manifest getManifest() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile.getManifest();
        }
        if (this.parentArchive != null) {
            InputStream is;
            Manifest m;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            if (this.jarIS == null) {
                this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.uri.getSchemeSpecificPart())));
            }
            if ((m = this.jarIS.getManifest()) == null && (is = this.getEntry("META-INF/MANIFEST.MF")) != null) {
                m = new Manifest();
                m.read(is);
                is.close();
            }
            return m;
        }
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean exists() {
        return this.jarFile != null;
    }

    public boolean delete() {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.deleteFile((File)new File(this.uri));
    }

    public boolean renameTo(String name) {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.renameFile((File)new File(this.uri), (File)new File(name));
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        if (this.jarFile != null) {
            InputJarArchive ija = new InputJarArchive();
            JarEntry je = this.jarFile.getJarEntry(name);
            if (je != null) {
                JarInputStream jis = new JarInputStream(new BufferedInputStream(this.jarFile.getInputStream(je)));
                try {
                    ija.uri = new URI("jar", name, null);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                ija.jarIS = jis;
                ija.parentArchive = this;
                return ija;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollectionWrappedEnumeration<T>
    extends AbstractCollection<T> {
        private ArrayList<T> entries = null;
        private int nextSlot = 0;
        private final EnumerationFactory<T> factory;
        private Enumeration<T> e;

        CollectionWrappedEnumeration(EnumerationFactory<T> factory) {
            this.factory = factory;
            this.e = factory.enumeration();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return CollectionWrappedEnumeration.this.entries != null ? CollectionWrappedEnumeration.this.nextSlot < CollectionWrappedEnumeration.this.entries.size() : CollectionWrappedEnumeration.this.e.hasMoreElements();
                }

                @Override
                public T next() {
                    Object result = null;
                    if (CollectionWrappedEnumeration.this.entries != null) {
                        if (CollectionWrappedEnumeration.this.nextSlot >= CollectionWrappedEnumeration.this.entries.size()) {
                            throw new NoSuchElementException();
                        }
                        result = CollectionWrappedEnumeration.this.entries.get(CollectionWrappedEnumeration.this.nextSlot++);
                    } else {
                        result = CollectionWrappedEnumeration.this.e.nextElement();
                        CollectionWrappedEnumeration.this.nextSlot++;
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            if (this.entries == null) {
                this.populateEntries();
            }
            return this.entries.size();
        }

        private void populateEntries() {
            this.entries = new ArrayList();
            Enumeration<T> newE = this.factory.enumeration();
            while (newE.hasMoreElements()) {
                this.entries.add(newE.nextElement());
            }
            this.e = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static interface EnumerationFactory<T> {
            public Enumeration<T> enumeration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class EntryEnumeration
    implements Enumeration<String> {
        private JarEntry nextMatchingEntry;
        private final boolean directoriesOnly;

        private EntryEnumeration(boolean directoriesOnly) {
            this.directoriesOnly = directoriesOnly;
        }

        protected void completeInit() {
            this.nextMatchingEntry = this.skipToNextMatchingEntry();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextMatchingEntry != null;
        }

        @Override
        public String nextElement() {
            if (this.nextMatchingEntry == null) {
                throw new NoSuchElementException();
            }
            String answer = this.nextMatchingEntry.getName();
            this.nextMatchingEntry = this.skipToNextMatchingEntry();
            return answer;
        }

        protected abstract JarEntry getNextJarEntry();

        protected JarEntry skipToNextMatchingEntry() {
            JarEntry candidateNextEntry;
            while ((candidateNextEntry = this.getNextJarEntry()) != null && (this.directoriesOnly != candidateNextEntry.isDirectory() || candidateNextEntry.getName().equals("META-INF/MANIFEST.MF"))) {
            }
            return candidateNextEntry;
        }
    }

    private class SubarchiveEntryEnumeration
    extends EntryEnumeration {
        private final JarInputStream jis;
        private boolean reachedEndOfStream;

        private SubarchiveEntryEnumeration(boolean directoriesOnly) throws IOException {
            super(directoriesOnly);
            this.reachedEndOfStream = false;
            this.jis = new JarInputStream(((InputJarArchive)InputJarArchive.this).parentArchive.jarFile.getInputStream(((InputJarArchive)InputJarArchive.this).parentArchive.jarFile.getJarEntry(InputJarArchive.this.uri.getSchemeSpecificPart())));
            this.completeInit();
        }

        protected JarEntry getNextJarEntry() {
            if (this.reachedEndOfStream) {
                return null;
            }
            try {
                JarEntry result = this.jis.getNextJarEntry();
                if (result == null) {
                    this.jis.close();
                    this.reachedEndOfStream = true;
                }
                return result;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.reachedEndOfStream) {
                this.jis.close();
            }
        }
    }

    private class TopLevelEntryEnumeration
    extends EntryEnumeration {
        private final Enumeration<JarEntry> jarEnum;

        private TopLevelEntryEnumeration(boolean directoriesOnly) {
            super(directoriesOnly);
            this.jarEnum = InputJarArchive.this.jarFile.entries();
            this.completeInit();
        }

        protected JarEntry getNextJarEntry() {
            if (this.jarEnum.hasMoreElements()) {
                return this.jarEnum.nextElement();
            }
            return null;
        }
    }
}

