/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.reader;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.reader.CharactersEvent;
import com.sun.jersey.json.impl.reader.EndDocumentEvent;
import com.sun.jersey.json.impl.reader.EndElementEvent;
import com.sun.jersey.json.impl.reader.JsonLexer;
import com.sun.jersey.json.impl.reader.JsonNamespaceContext;
import com.sun.jersey.json.impl.reader.JsonReaderXmlEvent;
import com.sun.jersey.json.impl.reader.JsonToken;
import com.sun.jersey.json.impl.reader.StartDocumentEvent;
import com.sun.jersey.json.impl.reader.StartElementEvent;
import com.sun.jersey.json.impl.reader.StaxLocation;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class JsonXmlStreamReader
implements XMLStreamReader {
    private static final Logger LOGGER = Logger.getLogger(JsonXmlStreamReader.class.getName());
    boolean jsonRootUnwrapping;
    String rootElementName;
    final Map<String, String> revertedXml2JsonNs = new HashMap<String, String>();
    final Collection<String> attrAsElemNames = new LinkedList<String>();
    JsonLexer lexer;
    JsonToken lastToken;
    final Queue<JsonReaderXmlEvent> eventQueue = new LinkedList<JsonReaderXmlEvent>();
    List<ProcessingState> processingStack;
    int depth;
    private static final Set<Integer> valueTokenTypes = new HashSet<Integer>(){
        {
            this.add(10);
            this.add(9);
            this.add(11);
            this.add(8);
            this.add(7);
        }
    };

    public JsonXmlStreamReader(Reader reader, JSONConfiguration config) throws IOException {
        this(reader, config.isRootUnwrapping() ? "rootElement" : null, config);
    }

    public JsonXmlStreamReader(Reader reader, String rootElementName) throws IOException {
        this(reader, rootElementName, JSONConfiguration.DEFAULT);
    }

    public JsonXmlStreamReader(Reader reader, String rootElementName, JSONConfiguration config) throws IOException {
        this.jsonRootUnwrapping = rootElementName != null;
        this.rootElementName = rootElementName;
        if (config.getAttributeAsElements() != null) {
            this.attrAsElemNames.addAll(config.getAttributeAsElements());
        }
        if (config.getXml2JsonNs() != null) {
            for (String uri : config.getXml2JsonNs().keySet()) {
                this.revertedXml2JsonNs.put(config.getXml2JsonNs().get(uri), uri);
            }
        }
        this.lexer = new JsonLexer(reader);
        this.depth = 0;
        this.processingStack = new ArrayList<ProcessingState>();
        this.processingStack.add(new ProcessingState());
        this.readNext();
    }

    void colon() throws IOException {
        JsonToken token = this.nextToken();
        if (token.tokenType != 5) {
            throw new IOException("Colon expected instead of \"" + token.tokenText + "\"");
        }
    }

    JsonToken nextToken() throws IOException {
        JsonToken result = this.lexer.yylex();
        return result;
    }

    private void valueRead() {
        if (LaState.BEFORE_VALUE_IN_KV_PAIR == this.processingStack.get((int)this.depth).state) {
            this.processingStack.get((int)this.depth).state = LaState.AFTER_OBJ_KV_PAIR;
        } else if (LaState.BEFORE_NEXT_ARRAY_ELEM == this.processingStack.get((int)this.depth).state) {
            this.processingStack.get((int)this.depth).state = LaState.AFTER_ARRAY_ELEM;
        } else if (LaState.AFTER_ARRAY_START_BRACE == this.processingStack.get((int)this.depth).state) {
            this.processingStack.get((int)this.depth).state = LaState.AFTER_ARRAY_ELEM;
        }
    }

    private void readNext() throws IOException {
        this.readNext(false);
    }

    private void readNext(boolean checkAttributesOnly) throws IOException {
        if (!checkAttributesOnly) {
            this.eventQueue.poll();
        }
        while (this.eventQueue.isEmpty() || checkAttributesOnly) {
            this.lastToken = this.nextToken();
            if (null == this.lastToken || LaState.END == this.processingStack.get((int)this.depth).state) {
                if (this.jsonRootUnwrapping) {
                    this.generateEEEvent(this.processingStack.get((int)this.depth).lastName);
                }
                this.eventQueue.add(new EndDocumentEvent(new StaxLocation(this.lexer)));
                break;
            }
            block0 : switch (this.processingStack.get((int)this.depth).state) {
                case START: {
                    StartElementEvent event;
                    if (0 == this.depth) {
                        this.eventQueue.add(new StartDocumentEvent(new StaxLocation(this.lexer)));
                        this.processingStack.get((int)this.depth).state = LaState.AFTER_OBJ_START_BRACE;
                        if (this.jsonRootUnwrapping) {
                            this.processingStack.get((int)this.depth).lastName = this.rootElementName;
                            event = this.generateSEEvent(this.processingStack.get((int)this.depth).lastName);
                            this.processingStack.get((int)this.depth).eventToReadAttributesFor = event;
                        }
                        switch (this.lastToken.tokenType) {
                            case 1: {
                                this.processingStack.add(new ProcessingState(LaState.AFTER_OBJ_START_BRACE));
                                ++this.depth;
                                break;
                            }
                            case 3: {
                                this.processingStack.add(new ProcessingState(LaState.AFTER_ARRAY_START_BRACE));
                                ++this.depth;
                                break;
                            }
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                this.eventQueue.add(new CharactersEvent(this.lastToken.tokenText, new StaxLocation(this.lexer)));
                                this.processingStack.get((int)this.depth).state = LaState.END;
                                break;
                            }
                        }
                    }
                    this.processingStack.get((int)this.depth).state = LaState.AFTER_OBJ_START_BRACE;
                    break;
                }
                case AFTER_OBJ_START_BRACE: {
                    StartElementEvent event;
                    switch (this.lastToken.tokenType) {
                        case 7: {
                            if (this.lastToken.tokenText.startsWith("@") || this.attrAsElemNames.contains(this.lastToken.tokenText)) {
                                String attrName = this.lastToken.tokenText.startsWith("@") ? this.lastToken.tokenText : "@" + this.lastToken.tokenText;
                                this.colon();
                                this.lastToken = this.nextToken();
                                if (!valueTokenTypes.contains(this.lastToken.tokenType)) {
                                    throw new IOException("Attribute value expected instead of \"" + this.lastToken.tokenText + "\"");
                                }
                                if (null != this.processingStack.get((int)(this.depth - 1)).eventToReadAttributesFor) {
                                    this.processingStack.get((int)(this.depth - 1)).eventToReadAttributesFor.addAttribute(this.createQName(attrName.substring(1)), this.lastToken.tokenText);
                                }
                                this.lastToken = this.nextToken();
                                switch (this.lastToken.tokenType) {
                                    case 2: {
                                        this.processingStack.remove(this.depth);
                                        --this.depth;
                                        this.valueRead();
                                        checkAttributesOnly = false;
                                        break block0;
                                    }
                                    case 6: {
                                        break block0;
                                    }
                                }
                                throw new IOException("'\"', or '}' expected instead of \"" + this.lastToken.tokenText + "\"");
                            }
                        }
                        event = this.generateSEEvent(this.lastToken.tokenText);
                        this.processingStack.get((int)this.depth).eventToReadAttributesFor = event;
                        checkAttributesOnly = false;
                        this.processingStack.get((int)this.depth).lastName = this.lastToken.tokenText;
                        this.colon();
                        this.processingStack.get((int)this.depth).state = LaState.BEFORE_VALUE_IN_KV_PAIR;
                        break block0;
                        case 2: {
                            this.generateEEEvent(this.processingStack.get((int)this.depth).lastName);
                            checkAttributesOnly = false;
                            this.processingStack.remove(this.depth);
                            --this.depth;
                            this.valueRead();
                            break block0;
                        }
                    }
                    break;
                }
                case BEFORE_OBJ_NEXT_KV_PAIR: {
                    StartElementEvent event;
                    switch (this.lastToken.tokenType) {
                        case 7: {
                            event = this.generateSEEvent(this.lastToken.tokenText);
                            this.processingStack.get((int)this.depth).eventToReadAttributesFor = event;
                            this.processingStack.get((int)this.depth).lastName = this.lastToken.tokenText;
                            this.colon();
                            this.processingStack.get((int)this.depth).state = LaState.BEFORE_VALUE_IN_KV_PAIR;
                            break block0;
                        }
                    }
                    break;
                }
                case BEFORE_VALUE_IN_KV_PAIR: {
                    switch (this.lastToken.tokenType) {
                        case 1: {
                            this.processingStack.add(new ProcessingState(LaState.AFTER_OBJ_START_BRACE));
                            ++this.depth;
                            break block0;
                        }
                        case 3: {
                            this.processingStack.add(new ProcessingState(LaState.AFTER_ARRAY_START_BRACE));
                            ++this.depth;
                            break block0;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            this.eventQueue.add(new CharactersEvent(this.lastToken.tokenText, new StaxLocation(this.lexer)));
                            this.processingStack.get((int)this.depth).state = LaState.AFTER_OBJ_KV_PAIR;
                            break block0;
                        }
                        case 11: {
                            this.processingStack.get((int)this.depth).state = LaState.AFTER_OBJ_KV_PAIR;
                            break block0;
                        }
                    }
                    break;
                }
                case AFTER_OBJ_KV_PAIR: {
                    switch (this.lastToken.tokenType) {
                        case 6: {
                            this.processingStack.get((int)this.depth).state = LaState.BEFORE_OBJ_NEXT_KV_PAIR;
                            this.generateEEEvent(this.processingStack.get((int)this.depth).lastName);
                            break block0;
                        }
                        case 2: {
                            this.generateEEEvent(this.processingStack.get((int)this.depth).lastName);
                            this.processingStack.remove(this.depth);
                            --this.depth;
                            this.valueRead();
                            break block0;
                        }
                    }
                    break;
                }
                case AFTER_ARRAY_START_BRACE: {
                    switch (this.lastToken.tokenType) {
                        case 1: {
                            this.processingStack.add(new ProcessingState(LaState.AFTER_OBJ_START_BRACE));
                            this.processingStack.get((int)this.depth).eventToReadAttributesFor = this.processingStack.get((int)(this.depth - 1)).eventToReadAttributesFor;
                            ++this.depth;
                            break block0;
                        }
                        case 3: {
                            this.processingStack.add(new ProcessingState(LaState.AFTER_ARRAY_START_BRACE));
                            ++this.depth;
                            break block0;
                        }
                        case 4: {
                            this.processingStack.remove(this.depth);
                            --this.depth;
                            this.valueRead();
                            break block0;
                        }
                        case 7: {
                            this.eventQueue.add(new CharactersEvent(this.lastToken.tokenText, new StaxLocation(this.lexer)));
                            this.processingStack.get((int)this.depth).state = LaState.AFTER_ARRAY_ELEM;
                            break block0;
                        }
                    }
                    break;
                }
                case BEFORE_NEXT_ARRAY_ELEM: {
                    StartElementEvent event = this.generateSEEvent(this.processingStack.get((int)(this.depth - 1)).lastName);
                    switch (this.lastToken.tokenType) {
                        case 1: {
                            this.processingStack.add(new ProcessingState(LaState.AFTER_OBJ_START_BRACE));
                            this.processingStack.get((int)this.depth).eventToReadAttributesFor = event;
                            ++this.depth;
                            break block0;
                        }
                        case 3: {
                            this.processingStack.add(new ProcessingState(LaState.AFTER_ARRAY_START_BRACE));
                            ++this.depth;
                            break block0;
                        }
                        case 7: {
                            this.eventQueue.add(new CharactersEvent(this.lastToken.tokenText, new StaxLocation(this.lexer)));
                            this.processingStack.get((int)this.depth).state = LaState.AFTER_ARRAY_ELEM;
                            break block0;
                        }
                    }
                    break;
                }
                case AFTER_ARRAY_ELEM: {
                    switch (this.lastToken.tokenType) {
                        case 4: {
                            this.processingStack.remove(this.depth);
                            --this.depth;
                            this.valueRead();
                            break block0;
                        }
                        case 6: {
                            this.processingStack.get((int)this.depth).state = LaState.BEFORE_NEXT_ARRAY_ELEM;
                            this.generateEEEvent(this.processingStack.get((int)(this.depth - 1)).lastName);
                            break block0;
                        }
                    }
                }
            }
        }
    }

    public int getAttributeCount() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributeCount");
        assert (!this.eventQueue.isEmpty());
        if (!this.eventQueue.peek().attributesChecked) {
            try {
                this.readNext(true);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.eventQueue.peek().attributesChecked = true;
        }
        int result = this.eventQueue.peek().getAttributeCount();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributeCount", result);
        return result;
    }

    public int getEventType() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getEventType");
        assert (!this.eventQueue.isEmpty());
        int result = this.eventQueue.peek().getEventType();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getEventType", result);
        return result;
    }

    public int getNamespaceCount() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getNamespaceCount");
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getNamespaceCount", 0);
        return 0;
    }

    public int getTextLength() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getTextLength");
        assert (!this.eventQueue.isEmpty());
        int result = this.eventQueue.peek().getTextLength();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getTextLength", result);
        return result;
    }

    public int getTextStart() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getTextStart");
        assert (!this.eventQueue.isEmpty());
        int result = this.eventQueue.peek().getTextStart();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getTextStart", result);
        return result;
    }

    public int next() throws XMLStreamException {
        try {
            this.readNext();
            return this.eventQueue.peek().getEventType();
        }
        catch (IOException ex) {
            Logger.getLogger(JsonXmlStreamReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new XMLStreamException(ex);
        }
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasNext() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCharacters() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "isCharacters");
        assert (!this.eventQueue.isEmpty());
        boolean result = this.eventQueue.peek().isCharacters();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "isCharacters", result);
        return result;
    }

    public boolean isEndElement() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "isEndElement");
        assert (!this.eventQueue.isEmpty());
        boolean result = this.eventQueue.peek().isEndElement();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "isEndElement", result);
        return result;
    }

    public boolean isStandalone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isStartElement() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "isStartElement");
        assert (!this.eventQueue.isEmpty());
        boolean result = this.eventQueue.peek().isStartElement();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "isStartElement", result);
        return result;
    }

    public boolean isWhiteSpace() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "isWhiteSpace");
        boolean result = false;
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "isWhiteSpace", result);
        return result;
    }

    public boolean standaloneSet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public char[] getTextCharacters() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getTextCharacters");
        assert (!this.eventQueue.isEmpty());
        char[] result = this.eventQueue.peek().getTextCharacters();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getTextCharacters", result);
        return result;
    }

    public boolean isAttributeSpecified(int attribute) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "isAttributeSpecified");
        assert (!this.eventQueue.isEmpty());
        boolean result = this.eventQueue.peek().isAttributeSpecified(attribute);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "isAttributeSpecified", result);
        return result;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getTextCharacters");
        assert (!this.eventQueue.isEmpty());
        int result = this.eventQueue.peek().getTextCharacters(sourceStart, target, targetStart, length);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getTextCharacters", result);
        return result;
    }

    public String getCharacterEncodingScheme() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getElementText() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getEncoding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLocalName() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getLocalName");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getLocalName();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getLocalName", result);
        return result;
    }

    public String getNamespaceURI() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getNamespaceURI");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getName().getNamespaceURI();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getNamespaceURI", result);
        return result;
    }

    public String getPIData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getPITarget() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getPrefix() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getPrefix");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getPrefix();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getPrefix", result);
        return result;
    }

    public String getText() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getText");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getText();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getText", result);
        return result;
    }

    public String getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getAttributeLocalName(int index) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributeLocalName");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getAttributeLocalName(index);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributeLocalName", result);
        return result;
    }

    public QName getAttributeName(int index) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributeName");
        assert (!this.eventQueue.isEmpty());
        QName result = this.eventQueue.peek().getAttributeName(index);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributeName", result);
        return result;
    }

    public String getAttributeNamespace(int index) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributeNamespace");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getAttributeNamespace(index);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributeNamespace", result);
        return result;
    }

    public String getAttributePrefix(int index) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributePrefix");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getAttributePrefix(index);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributePrefix", result);
        return result;
    }

    public String getAttributeType(int index) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributeType");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getAttributeType(index);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributeType", result);
        return result;
    }

    public String getAttributeValue(int index) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributeValue");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getAttributeValue(index);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributeValue", result);
        return result;
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getAttributeValue");
        assert (!this.eventQueue.isEmpty());
        String result = this.eventQueue.peek().getAttributeValue(namespaceURI, localName);
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getAttributeValue", result);
        return result;
    }

    public String getNamespacePrefix(int arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getNamespaceURI(int arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public NamespaceContext getNamespaceContext() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getNamespaceContext");
        JsonNamespaceContext result = new JsonNamespaceContext();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getNamespaceContext", result);
        return result;
    }

    public QName getName() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getName");
        assert (!this.eventQueue.isEmpty());
        QName result = this.eventQueue.peek().getName();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getName");
        return result;
    }

    public Location getLocation() {
        LOGGER.entering(JsonXmlStreamReader.class.getName(), "getLocation");
        assert (!this.eventQueue.isEmpty());
        Location result = this.eventQueue.peek().getLocation();
        LOGGER.exiting(JsonXmlStreamReader.class.getName(), "getLocation", result);
        return result;
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getNamespaceURI(String arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private StartElementEvent generateSEEvent(String name) {
        StartElementEvent event = null;
        if (!"$".equals(name)) {
            event = new StartElementEvent(this.createQName(name), new StaxLocation(this.lexer));
            this.eventQueue.add(event);
        }
        return event;
    }

    private void generateEEEvent(String name) {
        if (null != name && !"$".equals(name)) {
            this.eventQueue.add(new EndElementEvent(this.createQName(name), new StaxLocation(this.lexer)));
        }
    }

    private QName createQName(String name) {
        if (this.revertedXml2JsonNs.isEmpty() || !name.contains(".")) {
            return new QName(name);
        }
        int dotIndex = name.indexOf(".");
        String prefix = name.substring(0, dotIndex);
        String suffix = name.substring(dotIndex + 1);
        return this.revertedXml2JsonNs.containsKey(prefix) ? new QName(this.revertedXml2JsonNs.get(prefix), suffix) : new QName(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LaState {
        START,
        END,
        AFTER_OBJ_START_BRACE,
        BEFORE_OBJ_NEXT_KV_PAIR,
        BEFORE_COLON_IN_KV_PAIR,
        BEFORE_VALUE_IN_KV_PAIR,
        AFTER_OBJ_KV_PAIR,
        AFTER_ARRAY_START_BRACE,
        BEFORE_NEXT_ARRAY_ELEM,
        AFTER_ARRAY_ELEM;

    }

    private static final class ProcessingState {
        String lastName;
        LaState state;
        JsonReaderXmlEvent eventToReadAttributesFor;

        ProcessingState() {
            this(LaState.START);
        }

        ProcessingState(LaState state) {
            this(state, null);
        }

        ProcessingState(LaState state, String name) {
            this.state = state;
            this.lastName = name;
        }

        public String toString() {
            return String.format("{lastName:%s,laState:%s}", new Object[]{this.lastName, this.state});
        }
    }
}

