/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.webservices.SOAPMessageContext;
import org.glassfish.webservices.monitoring.AuthenticationListener;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.EndpointImpl;
import org.glassfish.webservices.monitoring.EndpointLifecycleListener;
import org.glassfish.webservices.monitoring.EndpointType;
import org.glassfish.webservices.monitoring.GlobalMessageListener;
import org.glassfish.webservices.monitoring.JAXRPCEndpointImpl;
import org.glassfish.webservices.monitoring.JAXWSEndpointImpl;
import org.glassfish.webservices.monitoring.LogAuthenticationListener;
import org.glassfish.webservices.monitoring.TransportInfo;
import org.glassfish.webservices.monitoring.WebServiceEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebServiceEngineImpl
implements WebServiceEngine {
    protected final Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    protected final List<EndpointLifecycleListener> lifecycleListeners = new ArrayList<EndpointLifecycleListener>();
    protected final List<AuthenticationListener> authListeners = new ArrayList<AuthenticationListener>();
    protected volatile GlobalMessageListener globalMessageListener = null;
    static final ThreadLocal servletThreadLocal = new ThreadLocal();
    public static final Logger sLogger = LogDomains.getLogger(WebServiceEngineImpl.class, (String)"javax.enterprise.webservices");
    private static final WebServiceEngineImpl INSTANCE = new WebServiceEngineImpl();

    private WebServiceEngineImpl() {
        this.addAuthListener(new LogAuthenticationListener());
    }

    public static WebServiceEngineImpl getInstance() {
        return INSTANCE;
    }

    public EndpointImpl createHandler(WebServiceEndpoint endpointDesc) {
        EndpointImpl newEndpoint = this.createEndpointInfo(endpointDesc);
        if (newEndpoint == null) {
            return null;
        }
        String key = newEndpoint.getEndpointSelector();
        this.endpoints.put(key, newEndpoint);
        for (EndpointLifecycleListener listener : this.lifecycleListeners) {
            listener.endpointAdded(newEndpoint);
        }
        return newEndpoint;
    }

    public EndpointImpl createHandler(SystemHandlerDelegate parent, WebServiceEndpoint endpointDesc) {
        EndpointImpl newEndpoint = this.createHandler(endpointDesc);
        ((JAXRPCEndpointImpl)newEndpoint).setParent(parent);
        return newEndpoint;
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        return this.endpoints.get(uri);
    }

    @Override
    public Iterator<Endpoint> getEndpoints() {
        return this.endpoints.values().iterator();
    }

    public void removeHandler(WebServiceEndpoint endpointDesc) {
        EndpointImpl endpoint = (EndpointImpl)endpointDesc.getExtraAttribute("MONITORING_ENDPOINT");
        if (endpoint == null) {
            return;
        }
        this.endpoints.remove(endpoint.getEndpointSelector());
        for (EndpointLifecycleListener listener : this.lifecycleListeners) {
            listener.endpointRemoved(endpoint);
        }
        endpoint.setDescriptor(null);
    }

    @Override
    public void addLifecycleListener(EndpointLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(EndpointLifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    @Override
    public void addAuthListener(AuthenticationListener listener) {
        this.authListeners.add(listener);
    }

    @Override
    public void removeAuthListener(AuthenticationListener listener) {
        this.authListeners.remove(listener);
    }

    public Collection<AuthenticationListener> getAuthListeners() {
        return this.authListeners;
    }

    @Override
    public GlobalMessageListener getGlobalMessageListener() {
        return this.globalMessageListener;
    }

    @Override
    public void setGlobalMessageListener(GlobalMessageListener listener) {
        this.globalMessageListener = listener;
    }

    public boolean hasGlobalMessageListener() {
        return this.globalMessageListener != null;
    }

    private EndpointImpl createEndpointInfo(WebServiceEndpoint endpoint) {
        try {
            String endpointURL = endpoint.getEndpointAddressUri();
            XModuleType moduleType = endpoint.getWebService().getWebServicesDescriptor().getModuleType();
            EndpointType endpointType = XModuleType.EJB == moduleType ? EndpointType.EJB_ENDPOINT : EndpointType.SERVLET_ENDPOINT;
            EndpointImpl newEndpoint = endpoint.getWebService().hasMappingFile() ? new JAXRPCEndpointImpl(endpointURL, endpointType) : new JAXWSEndpointImpl(endpointURL, endpointType);
            newEndpoint.setDescriptor(endpoint);
            return newEndpoint;
        }
        catch (Exception e) {
            sLogger.log(Level.SEVERE, "Exception in creating endpoint", e);
            return null;
        }
    }

    public String preProcessRequest(Endpoint endpoint) {
        if (this.globalMessageListener == null) {
            return null;
        }
        return this.globalMessageListener.preProcessRequest(endpoint);
    }

    public void processRequest(String messageID, com.sun.xml.rpc.spi.runtime.SOAPMessageContext context, TransportInfo info) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processRequest(messageID, context, info);
    }

    public void processResponse(String messageID, com.sun.xml.rpc.spi.runtime.SOAPMessageContext context) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processResponse(messageID, context);
    }

    public void processRequest(String messageID, SOAPMessageContext context, TransportInfo info) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processRequest(messageID, context, info);
    }

    public void processResponse(String messageID, SOAPMessageContext context) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.processResponse(messageID, context);
    }

    public void postProcessResponse(String messageID, TransportInfo info) {
        if (this.globalMessageListener == null) {
            return;
        }
        this.globalMessageListener.postProcessResponse(messageID, info);
    }

    public ThreadLocal getThreadLocal() {
        return servletThreadLocal;
    }
}

