/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.ReaderThread;

public class ReaderThreadImpl
implements ReaderThread,
Work {
    private ORB orb;
    private CorbaConnection connection;
    private boolean keepRunning;
    private long enqueueTime;
    private ORBUtilSystemException wrapper;

    public ReaderThreadImpl(ORB orb, CorbaConnection connection) {
        this.orb = orb;
        this.connection = connection;
        this.keepRunning = true;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    }

    @Override
    public CorbaConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void close() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".close: " + this.connection);
        }
        this.keepRunning = false;
    }

    private synchronized boolean isRunning() {
        return this.keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Start ReaderThread: " + this.connection);
            }
            while (this.isRunning()) {
                block14: {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: Start ReaderThread cycle: " + this.connection);
                    }
                    if (!this.connection.read()) break block14;
                    return;
                }
                try {
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint(".doWork: End ReaderThread cycle: " + this.connection);
                }
                catch (Throwable t) {
                    this.wrapper.exceptionInReaderThread(t);
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: exception in read: " + this.connection, t);
                    }
                    this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getConnection().getEventHandler());
                    try {
                        if (!this.isRunning()) continue;
                        this.getConnection().close();
                    }
                    catch (Exception exc) {
                        this.wrapper.ioExceptionOnClose(exc);
                    }
                }
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Terminated ReaderThread: " + this.connection);
            }
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ReaderThread";
    }

    private void dprint(String msg) {
        ORBUtility.dprint("ReaderThreadImpl", msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }
}

