/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.NotLocalLocalCRDImpl;
import com.sun.corba.ee.impl.transport.CorbaContactInfoListIteratorImpl;
import com.sun.corba.ee.impl.transport.SharedCDRContactInfoImpl;
import com.sun.corba.ee.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.LoadBalancingComponent;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.UnaryBooleanFunction;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.SocketInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CorbaContactInfoListImpl
implements CorbaContactInfoList {
    protected ORB orb;
    protected LocalClientRequestDispatcher localClientRequestDispatcher;
    protected IOR targetIOR;
    protected IOR effectiveTargetIOR;
    protected List<CorbaContactInfo> effectiveTargetIORContactInfoList;
    protected CorbaContactInfo primaryContactInfo;
    private boolean usePerRequestLoadBalancing = false;
    private int startCount = 0;
    private UnaryBooleanFunction<CorbaContactInfo> testPred = new UnaryBooleanFunction<CorbaContactInfo>(){

        public boolean evaluate(CorbaContactInfo arg) {
            return !arg.getType().equals("IIOP_CLEAR_TEXT");
        }
    };
    private static ThreadLocal<Boolean> skipRotate = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private <T> List<T> filter(List<T> arg, UnaryBooleanFunction<T> pred) {
        ArrayList<T> result = new ArrayList<T>();
        for (T elem : arg) {
            if (!pred.evaluate(elem)) continue;
            result.add(elem);
        }
        return result;
    }

    public static void setSkipRotate() {
        skipRotate.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<CorbaContactInfo> rotate(List<CorbaContactInfo> arg) {
        if (skipRotate.get().booleanValue()) {
            skipRotate.set(false);
            return arg;
        }
        if (this.usePerRequestLoadBalancing) {
            if (this.orb.folbDebugFlag) {
                this.dprint(".rotate->: arg = " + arg + " startCount = " + this.startCount);
            }
            LinkedList<CorbaContactInfo> tempList = null;
            try {
                tempList = new LinkedList<CorbaContactInfo>(this.filter(arg, this.testPred));
                if (this.startCount >= tempList.size()) {
                    this.startCount = 0;
                }
                for (int ctr = 0; ctr < this.startCount; ++ctr) {
                    CorbaContactInfo element = tempList.removeLast();
                    tempList.addFirst(element);
                }
                ++this.startCount;
                LinkedList<CorbaContactInfo> linkedList = tempList;
                return linkedList;
            }
            finally {
                if (this.orb.folbDebugFlag) {
                    this.dprint(".rotate<-: result = " + tempList);
                }
            }
        }
        return arg;
    }

    public CorbaContactInfoListImpl(ORB orb) {
        this.orb = orb;
    }

    public CorbaContactInfoListImpl(ORB orb, IOR targetIOR) {
        this(orb);
        this.setTargetIOR(targetIOR);
    }

    @Override
    public synchronized Iterator<CorbaContactInfo> iterator() {
        this.createContactInfoList();
        CorbaContactInfoListIteratorImpl result = new CorbaContactInfoListIteratorImpl(this.orb, this, this.primaryContactInfo, this.rotate(this.effectiveTargetIORContactInfoList), this.usePerRequestLoadBalancing);
        return result;
    }

    @Override
    public synchronized void setTargetIOR(IOR targetIOR) {
        this.targetIOR = targetIOR;
        this.setEffectiveTargetIOR(targetIOR);
    }

    @Override
    public synchronized IOR getTargetIOR() {
        return this.targetIOR;
    }

    @Override
    public synchronized void setEffectiveTargetIOR(IOR effectiveTargetIOR) {
        this.effectiveTargetIOR = effectiveTargetIOR;
        this.effectiveTargetIORContactInfoList = null;
        if (this.primaryContactInfo != null && this.orb.getORBData().getIIOPPrimaryToContactInfo() != null) {
            this.orb.getORBData().getIIOPPrimaryToContactInfo().reset(this.primaryContactInfo);
        }
        this.primaryContactInfo = null;
        this.setLocalSubcontract();
        IIOPProfile prof = effectiveTargetIOR.getProfile();
        TaggedProfileTemplate temp = prof.getTaggedProfileTemplate();
        Iterator<TaggedComponent> lbcomps = temp.iteratorById(1398099461);
        if (lbcomps.hasNext()) {
            LoadBalancingComponent lbcomp = null;
            lbcomp = (LoadBalancingComponent)lbcomps.next();
            this.usePerRequestLoadBalancing = lbcomp.getLoadBalancingValue() == 1;
        }
    }

    @Override
    public synchronized IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    @Override
    public synchronized LocalClientRequestDispatcher getLocalClientRequestDispatcher() {
        return this.localClientRequestDispatcher;
    }

    @Override
    public synchronized int hashCode() {
        return this.targetIOR.hashCode();
    }

    private void createContactInfoList() {
        IIOPProfile iiopProfile = this.effectiveTargetIOR.getProfile();
        if (this.effectiveTargetIORContactInfoList == null) {
            this.effectiveTargetIORContactInfoList = new ArrayList<CorbaContactInfo>();
            String hostname = ((IIOPProfileTemplate)iiopProfile.getTaggedProfileTemplate()).getPrimaryAddress().getHost().toLowerCase();
            int port = ((IIOPProfileTemplate)iiopProfile.getTaggedProfileTemplate()).getPrimaryAddress().getPort();
            this.primaryContactInfo = this.createContactInfo("IIOP_CLEAR_TEXT", hostname, port);
            if (iiopProfile.isLocal()) {
                SharedCDRContactInfoImpl contactInfo = new SharedCDRContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition());
                this.effectiveTargetIORContactInfoList.add(contactInfo);
            } else {
                this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
            }
            if (this.orb.transportDebugFlag) {
                this.dprint(".createContactInfoList: first time for: " + iiopProfile + " list: " + this.effectiveTargetIORContactInfoList);
            }
        } else if (!iiopProfile.isLocal()) {
            this.addRemoteContactInfos(this.effectiveTargetIOR, this.effectiveTargetIORContactInfoList);
        } else if (this.orb.transportDebugFlag) {
            this.dprint(".createContactInfoList: subsequent for: " + iiopProfile + " colocated so no change");
        }
        if (this.orb.folbDebugFlag) {
            this.dprint(".createContactInfoList: effectiveTargetIORContactInfoList = " + this.effectiveTargetIORContactInfoList);
        }
    }

    private void addRemoteContactInfos(IOR effectiveTargetIOR, List<CorbaContactInfo> effectiveTargetIORContactInfoList) {
        List<? extends SocketInfo> socketInfos = this.orb.getORBData().getIORToSocketInfo().getSocketInfo(effectiveTargetIOR, effectiveTargetIORContactInfoList);
        if (socketInfos == effectiveTargetIORContactInfoList) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".addRemoteContactInfos: no change: " + socketInfos);
            }
            return;
        }
        for (SocketInfo socketInfo : socketInfos) {
            String type = socketInfo.getType();
            String host = socketInfo.getHost().toLowerCase();
            int port = socketInfo.getPort();
            CorbaContactInfo contactInfo = this.createContactInfo(type, host, port);
            effectiveTargetIORContactInfoList.add(contactInfo);
        }
    }

    protected CorbaContactInfo createContactInfo(String type, String hostname, int port) {
        return new SocketOrChannelContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), type, hostname, port);
    }

    protected void setLocalSubcontract() {
        if (!this.effectiveTargetIOR.getProfile().isLocal()) {
            this.localClientRequestDispatcher = new NotLocalLocalCRDImpl();
            return;
        }
        int scid = this.effectiveTargetIOR.getProfile().getObjectKeyTemplate().getSubcontractId();
        LocalClientRequestDispatcherFactory lcsf = this.orb.getRequestDispatcherRegistry().getLocalClientRequestDispatcherFactory(scid);
        if (lcsf != null) {
            this.localClientRequestDispatcher = lcsf.create(scid, this.effectiveTargetIOR);
        }
    }

    public CorbaContactInfo getPrimaryContactInfo() {
        return this.primaryContactInfo;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaContactInfoListImpl", msg);
    }
}

