/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol.giopmsgheaders;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class ReplyMessage_1_0
extends Message_1_0
implements ReplyMessage {
    private ORB orb = null;
    private ORBUtilSystemException wrapper = null;
    private ServiceContexts service_contexts = null;
    private int request_id = 0;
    private int reply_status = 0;
    private IOR ior = null;
    private String exClassName = null;
    private int minorCode = 0;
    private CompletionStatus completionStatus = null;

    ReplyMessage_1_0(ORB orb) {
        this.service_contexts = ServiceContextDefaults.makeServiceContexts(orb);
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
    }

    ReplyMessage_1_0(ORB orb, ServiceContexts _service_contexts, int _request_id, int _reply_status, IOR _ior) {
        super(1195986768, false, (byte)1, 0);
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        this.service_contexts = _service_contexts;
        this.request_id = _request_id;
        this.reply_status = _reply_status;
        this.ior = _ior;
    }

    @Override
    public int getRequestId() {
        return this.request_id;
    }

    @Override
    public int getReplyStatus() {
        return this.reply_status;
    }

    @Override
    public short getAddrDisposition() {
        return 0;
    }

    @Override
    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    @Override
    public SystemException getSystemException(String message) {
        return MessageBase.getSystemException(this.exClassName, this.minorCode, this.completionStatus, message, this.wrapper);
    }

    @Override
    public IOR getIOR() {
        return this.ior;
    }

    @Override
    public void setIOR(IOR ior) {
        this.ior = ior;
    }

    @Override
    public void read(org.omg.CORBA.portable.InputStream istream) {
        super.read(istream);
        this.service_contexts = ServiceContextDefaults.makeServiceContexts((InputStream)istream);
        this.request_id = istream.read_ulong();
        this.reply_status = istream.read_long();
        ReplyMessage_1_0.isValidReplyStatus(this.reply_status);
        if (this.reply_status == 2) {
            String reposId = istream.read_string();
            this.exClassName = ORBUtility.classNameOf(reposId);
            this.minorCode = istream.read_long();
            int status = istream.read_long();
            switch (status) {
                case 0: {
                    this.completionStatus = CompletionStatus.COMPLETED_YES;
                    break;
                }
                case 1: {
                    this.completionStatus = CompletionStatus.COMPLETED_NO;
                    break;
                }
                case 2: {
                    this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                    break;
                }
                default: {
                    throw this.wrapper.badCompletionStatusInReply(CompletionStatus.COMPLETED_MAYBE, (Object)status);
                }
            }
        } else if (this.reply_status != 1 && this.reply_status == 3) {
            CDRInputObject cdr = (CDRInputObject)istream;
            this.ior = IORFactories.makeIOR(this.orb, cdr);
        }
    }

    @Override
    public void write(org.omg.CORBA.portable.OutputStream ostream) {
        super.write(ostream);
        this.service_contexts.write((OutputStream)ostream, GIOPVersion.V1_0);
        ostream.write_ulong(this.request_id);
        ostream.write_long(this.reply_status);
    }

    public static void isValidReplyStatus(int replyStatus) {
        switch (replyStatus) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                ORBUtilSystemException localWrapper = ORB.getStaticLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
                throw localWrapper.illegalReplyStatus(CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    @Override
    public void callback(MessageHandler handler) throws IOException {
        handler.handleInput(this);
    }
}

