/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.ior;

import com.sun.corba.ee.impl.ior.EncapsulationUtility;
import com.sun.corba.ee.spi.ior.Identifiable;
import java.util.Arrays;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

@ManagedData
@Description(value="A generic implementation of an IIOP encapsulation with an integer id")
public abstract class GenericIdentifiable
implements Identifiable {
    private int id;
    private byte[] data;

    public GenericIdentifiable(int id, InputStream is) {
        this.id = id;
        this.data = EncapsulationUtility.readOctets(is);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void write(OutputStream os) {
        os.write_ulong(this.data.length);
        os.write_octet_array(this.data, 0, this.data.length);
    }

    public String toString() {
        return "GenericIdentifiable[id=" + this.getId() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericIdentifiable)) {
            return false;
        }
        GenericIdentifiable encaps = (GenericIdentifiable)obj;
        return this.getId() == encaps.getId() && Arrays.equals(this.getData(), encaps.getData());
    }

    public int hashCode() {
        int result = 17;
        for (int ctr = 0; ctr < this.data.length; ++ctr) {
            result = 37 * result + this.data[ctr];
        }
        return result;
    }

    public GenericIdentifiable(int id, byte[] data) {
        this.id = id;
        this.data = (byte[])data.clone();
    }

    @ManagedAttribute
    @Description(value="The tagged component or profile CDR encoded data")
    public byte[] getData() {
        return this.data;
    }
}

