/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.CodeSetCache;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class CodeSetConversion {
    private static CodeSetConversion implementation;
    private static final int FALLBACK_CODESET = 0;
    private CodeSetCache cache = new CodeSetCache();
    private ThreadLocal<HashMap<OSFCodeSetRegistry.Entry, BTCConverter>> cacheBTCC = new ThreadLocal(){

        public HashMap<OSFCodeSetRegistry.Entry, BTCConverter> initialValue() {
            return new HashMap<OSFCodeSetRegistry.Entry, BTCConverter>();
        }
    };
    private ThreadLocal<HashMap<OSFCodeSetRegistry.Entry, CTBConverter>> cacheCTBC = new ThreadLocal(){

        public HashMap<OSFCodeSetRegistry.Entry, CTBConverter> initialValue() {
            return new HashMap<OSFCodeSetRegistry.Entry, CTBConverter>();
        }
    };

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry codeset) {
        int alignment = !codeset.isFixedWidth() ? 1 : codeset.getMaxBytesPerChar();
        return new JavaCTBConverter(codeset, alignment);
    }

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry codeset, boolean littleEndian, boolean useByteOrderMarkers) {
        if (codeset == OSFCodeSetRegistry.UCS_2) {
            return new UTF16CTBConverter(littleEndian);
        }
        if (codeset == OSFCodeSetRegistry.UTF_16) {
            if (useByteOrderMarkers) {
                return new UTF16CTBConverter();
            }
            return new UTF16CTBConverter(littleEndian);
        }
        int alignment = !codeset.isFixedWidth() ? 1 : codeset.getMaxBytesPerChar();
        JavaCTBConverter converter = null;
        Map m = this.cacheCTBC.get();
        converter = (JavaCTBConverter)m.get(codeset);
        if (converter == null) {
            converter = new JavaCTBConverter(codeset, alignment);
            m.put(codeset, converter);
        } else if (((CTBConverter)converter).getAlignment() != alignment) {
            converter.setAlignment(alignment);
        }
        return converter;
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry codeset) {
        return new JavaBTCConverter(codeset);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry codeset, boolean defaultToLittleEndian) {
        if (codeset == OSFCodeSetRegistry.UTF_16 || codeset == OSFCodeSetRegistry.UCS_2) {
            return new UTF16BTCConverter(defaultToLittleEndian);
        }
        JavaBTCConverter converter = null;
        Map m = this.cacheBTCC.get();
        converter = (JavaBTCConverter)m.get(codeset);
        if (converter == null) {
            converter = new JavaBTCConverter(codeset);
            m.put(codeset, converter);
        }
        return converter;
    }

    private int selectEncoding(CodeSetComponentInfo.CodeSetComponent client, CodeSetComponentInfo.CodeSetComponent server) {
        int i;
        int serverNative = server.nativeCodeSet;
        if (serverNative == 0) {
            if (server.conversionCodeSets.length > 0) {
                serverNative = server.conversionCodeSets[0];
            } else {
                return 0;
            }
        }
        if (client.nativeCodeSet == serverNative) {
            return serverNative;
        }
        for (i = 0; i < client.conversionCodeSets.length; ++i) {
            if (serverNative != client.conversionCodeSets[i]) continue;
            return serverNative;
        }
        for (i = 0; i < server.conversionCodeSets.length; ++i) {
            if (client.nativeCodeSet != server.conversionCodeSets[i]) continue;
            return client.nativeCodeSet;
        }
        for (i = 0; i < server.conversionCodeSets.length; ++i) {
            for (int y = 0; y < client.conversionCodeSets.length; ++y) {
                if (server.conversionCodeSets[i] != client.conversionCodeSets[y]) continue;
                return server.conversionCodeSets[i];
            }
        }
        return 0;
    }

    public CodeSetComponentInfo.CodeSetContext negotiate(CodeSetComponentInfo client, CodeSetComponentInfo server) {
        int wcharData;
        int charData = this.selectEncoding(client.getCharComponent(), server.getCharComponent());
        if (charData == 0) {
            charData = OSFCodeSetRegistry.UTF_8.getNumber();
        }
        if ((wcharData = this.selectEncoding(client.getWCharComponent(), server.getWCharComponent())) == 0) {
            wcharData = OSFCodeSetRegistry.UTF_16.getNumber();
        }
        return new CodeSetComponentInfo.CodeSetContext(charData, wcharData);
    }

    private CodeSetConversion() {
    }

    public static final CodeSetConversion impl() {
        return CodeSetConversionHolder.csc;
    }

    public static abstract class BTCConverter {
        protected static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        protected static final OMGSystemException omgWrapper = ORB.getStaticLogWrapperTable().get_RPC_ENCODING_OMG();

        public abstract boolean isFixedWidthEncoding();

        public abstract int getFixedCharWidth();

        public abstract int getNumChars();

        public abstract char[] getChars(byte[] var1, int var2, int var3);

        public abstract char[] getChars(ByteBuffer var1, int var2, int var3);
    }

    public static abstract class CTBConverter {
        protected static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        protected static final OMGSystemException omgWrapper = ORB.getStaticLogWrapperTable().get_RPC_ENCODING_OMG();

        public abstract void convert(char var1);

        public abstract void convert(String var1);

        public abstract int getNumBytes();

        public abstract float getMaxBytesPerChar();

        public abstract boolean isFixedWidthEncoding();

        public abstract int getAlignment();

        public abstract byte[] getBytes();
    }

    private static class CodeSetConversionHolder {
        static final CodeSetConversion csc = new CodeSetConversion();

        private CodeSetConversionHolder() {
        }
    }

    private class JavaBTCConverter
    extends BTCConverter {
        protected CharsetDecoder btc;
        private char[] buffer;
        private int resultingNumChars;
        private OSFCodeSetRegistry.Entry codeset;
        WeakHashMap<ByteBuffer, char[]> cacheDecoder = new WeakHashMap();

        public JavaBTCConverter(OSFCodeSetRegistry.Entry codeset) {
            this.btc = this.getConverter(codeset.getName());
            this.codeset = codeset;
        }

        @Override
        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        @Override
        public final int getFixedCharWidth() {
            return this.codeset.getMaxBytesPerChar();
        }

        @Override
        public final int getNumChars() {
            return this.resultingNumChars;
        }

        @Override
        public char[] getChars(ByteBuffer buff, int offset, int numBytes) {
            try {
                buff.limit(numBytes);
                char[] myCache = this.cacheDecoder.get(buff);
                if (myCache == null) {
                    byte[] byteArray = new byte[numBytes];
                    buff.get(byteArray);
                    buff.position(0);
                    CharBuffer charBuf = this.btc.decode(buff);
                    ByteBuffer bbb = ByteBuffer.wrap(byteArray);
                    this.resultingNumChars = charBuf.limit();
                    this.buffer = new char[this.resultingNumChars];
                    charBuf.get(this.buffer, 0, this.resultingNumChars).position(0);
                    this.cacheDecoder.put(bbb, this.buffer);
                } else {
                    this.buffer = myCache;
                    this.resultingNumChars = myCache.length;
                }
                return this.buffer;
            }
            catch (IllegalStateException ile) {
                throw wrapper.btcConverterFailure(ile);
            }
            catch (MalformedInputException mie) {
                throw wrapper.badUnicodePair(mie);
            }
            catch (UnmappableCharacterException uce) {
                throw omgWrapper.charNotInCodeset(uce);
            }
            catch (CharacterCodingException cce) {
                throw wrapper.btcConverterFailure(cce);
            }
        }

        @Override
        public char[] getChars(byte[] bytes, int offset, int numBytes) {
            try {
                ByteBuffer byteBuf = ByteBuffer.wrap(bytes, offset, numBytes);
                CharBuffer charBuf = this.btc.decode(byteBuf);
                this.resultingNumChars = charBuf.limit();
                if (charBuf.limit() == charBuf.capacity()) {
                    this.buffer = charBuf.array();
                } else {
                    this.buffer = new char[charBuf.limit()];
                    charBuf.get(this.buffer, 0, charBuf.limit()).position(0);
                }
                return this.buffer;
            }
            catch (IllegalStateException ile) {
                throw wrapper.btcConverterFailure(ile);
            }
            catch (MalformedInputException mie) {
                throw wrapper.badUnicodePair(mie);
            }
            catch (UnmappableCharacterException uce) {
                throw omgWrapper.charNotInCodeset(uce);
            }
            catch (CharacterCodingException cce) {
                throw wrapper.btcConverterFailure(cce);
            }
        }

        protected CharsetDecoder getConverter(String javaCodeSetName) {
            CharsetDecoder result = null;
            try {
                result = CodeSetConversion.this.cache.getByteToCharConverter(javaCodeSetName);
                if (result == null) {
                    Charset tmpCharset = Charset.forName(javaCodeSetName);
                    result = tmpCharset.newDecoder();
                    CodeSetConversion.this.cache.setConverter(javaCodeSetName, result);
                }
            }
            catch (IllegalCharsetNameException icne) {
                throw wrapper.invalidBtcConverterName(icne, (Object)javaCodeSetName);
            }
            return result;
        }
    }

    private class JavaCTBConverter
    extends CTBConverter {
        private CharsetEncoder ctb;
        private int alignment;
        private char[] chars = null;
        private int numBytes = 0;
        private int numChars = 0;
        private ByteBuffer buffer;
        WeakHashMap<String, ByteBuffer> cacheEncoder = new WeakHashMap();
        private OSFCodeSetRegistry.Entry codeset;

        public JavaCTBConverter(OSFCodeSetRegistry.Entry codeset, int alignmentForEncoding) {
            try {
                this.ctb = CodeSetConversion.this.cache.getCharToByteConverter(codeset.getName());
                if (this.ctb == null) {
                    Charset tmpCharset = Charset.forName(codeset.getName());
                    this.ctb = tmpCharset.newEncoder();
                    CodeSetConversion.this.cache.setConverter(codeset.getName(), this.ctb);
                }
            }
            catch (IllegalCharsetNameException icne) {
                throw wrapper.invalidCtbConverterName(icne, (Object)codeset.getName());
            }
            catch (UnsupportedCharsetException ucne) {
                throw wrapper.invalidCtbConverterName(ucne, (Object)codeset.getName());
            }
            this.codeset = codeset;
            this.alignment = alignmentForEncoding;
        }

        @Override
        public final float getMaxBytesPerChar() {
            return this.ctb.maxBytesPerChar();
        }

        @Override
        public void convert(char chToConvert) {
            if (this.chars == null) {
                this.chars = new char[1];
            }
            this.chars[0] = chToConvert;
            this.numChars = 1;
            this.convertCharArray();
        }

        @Override
        public void convert(String strToConvert) {
            if (this.chars == null || this.chars.length < strToConvert.length()) {
                this.chars = new char[strToConvert.length()];
            }
            this.numChars = strToConvert.length();
            this.buffer = this.cacheEncoder.get(strToConvert);
            if (this.buffer != null) {
                this.numBytes = this.buffer.limit();
                this.buffer.position(0);
            } else {
                strToConvert.getChars(0, this.numChars, this.chars, 0);
                this.convertCharArray();
                this.cacheEncoder.put(strToConvert, this.buffer);
            }
        }

        void validateCodesetCache(ByteBuffer bb, String strToConvert) {
            try {
                Charset tmpCharset = Charset.forName(this.codeset.getName());
                CharsetDecoder result = tmpCharset.newDecoder();
                this.buffer.position(0);
                int pos = 0;
                CharBuffer charBuf = result.decode(this.buffer);
                if (!strToConvert.equals(charBuf.toString())) {
                    System.out.println(" buff position =" + pos + "newPos =" + this.buffer.position() + " orgString =" + strToConvert + " retString =" + charBuf.toString());
                    ORBUtility.dprint("CodeSetConversion", "CharBuff pos =" + charBuf.position() + " limit=" + charBuf.limit() + " buff limit = " + this.buffer.limit() + "numByte =" + this.numBytes + " numChar " + this.numChars);
                }
            }
            catch (Exception ex) {
                ORBUtility.dprint("CodeSetConversion", "Exception in CodeSet cache");
                ex.printStackTrace();
            }
        }

        @Override
        public final int getNumBytes() {
            return this.numBytes;
        }

        @Override
        public final int getAlignment() {
            return this.alignment;
        }

        public final void setAlignment(int newAlignment) {
            this.alignment = newAlignment;
        }

        @Override
        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        @Override
        public byte[] getBytes() {
            return this.buffer.array();
        }

        private void convertCharArray() {
            try {
                this.buffer = this.ctb.encode(CharBuffer.wrap(this.chars, 0, this.numChars));
                this.numBytes = this.buffer.limit();
            }
            catch (IllegalStateException ise) {
                throw wrapper.ctbConverterFailure(ise);
            }
            catch (MalformedInputException mie) {
                throw wrapper.badUnicodePair(mie);
            }
            catch (UnmappableCharacterException uce) {
                throw omgWrapper.charNotInCodeset(uce);
            }
            catch (CharacterCodingException cce) {
                throw wrapper.ctbConverterFailure(cce);
            }
        }
    }

    private class UTF16BTCConverter
    extends JavaBTCConverter {
        private boolean defaultToLittleEndian;
        private boolean converterUsesBOM;
        private static final char UTF16_BE_MARKER = '\ufeff';
        private static final char UTF16_LE_MARKER = '\ufffe';

        public UTF16BTCConverter(boolean defaultToLittleEndian) {
            super(OSFCodeSetRegistry.UTF_16);
            this.converterUsesBOM = true;
            this.defaultToLittleEndian = defaultToLittleEndian;
        }

        @Override
        public char[] getChars(ByteBuffer bytes, int offset, int numBytes) {
            byte[] marker = new byte[]{bytes.get(), bytes.get()};
            bytes.position(0);
            if (this.hasUTF16ByteOrderMarker(marker, 0, numBytes)) {
                if (!this.converterUsesBOM) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16);
                }
                this.converterUsesBOM = true;
                return super.getChars(bytes, offset, numBytes);
            }
            if (this.converterUsesBOM) {
                if (this.defaultToLittleEndian) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16LE);
                } else {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16BE);
                }
                this.converterUsesBOM = false;
            }
            return super.getChars(bytes, offset, numBytes);
        }

        @Override
        public char[] getChars(byte[] bytes, int offset, int numBytes) {
            if (this.hasUTF16ByteOrderMarker(bytes, offset, numBytes)) {
                if (!this.converterUsesBOM) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16);
                }
                this.converterUsesBOM = true;
                return super.getChars(bytes, offset, numBytes);
            }
            if (this.converterUsesBOM) {
                if (this.defaultToLittleEndian) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16LE);
                } else {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16BE);
                }
                this.converterUsesBOM = false;
            }
            return super.getChars(bytes, offset, numBytes);
        }

        private boolean hasUTF16ByteOrderMarker(byte[] array, int offset, int length) {
            if (length >= 4) {
                int b1 = array[offset] & 0xFF;
                int b2 = array[offset + 1] & 0xFF;
                char marker = (char)(b1 << 8 | b2 << 0);
                return marker == '\ufeff' || marker == '\ufffe';
            }
            return false;
        }

        private void switchToConverter(OSFCodeSetRegistry.Entry newCodeSet) {
            this.btc = super.getConverter(newCodeSet.getName());
        }
    }

    private class UTF16CTBConverter
    extends JavaCTBConverter {
        public UTF16CTBConverter() {
            super(OSFCodeSetRegistry.UTF_16, 2);
        }

        public UTF16CTBConverter(boolean littleEndian) {
            super(littleEndian ? OSFCodeSetRegistry.UTF_16LE : OSFCodeSetRegistry.UTF_16BE, 2);
        }
    }
}

