/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsScanner;
import com.sun.hk2.component.KeyValuePairParser;
import com.sun.hk2.component.LazyInhabitant;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;
import org.jvnet.hk2.component.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InhabitantsParser {
    public final Habitat habitat;
    private final Map<String, Class> replacements = new HashMap<String, Class>();

    public InhabitantsParser(Habitat habitat) {
        this.habitat = habitat;
    }

    public void drop(Class component) {
        this.drop(component.getName());
    }

    public void drop(String fullyQualifiedClassName) {
        this.replace(fullyQualifiedClassName, null);
    }

    public void replace(Class oldComponent, Class newComponent) {
        this.replace(oldComponent.getName(), newComponent);
    }

    public void replace(String oldComponentFullyQualifiedClassName, Class newComponent) {
        this.replacements.put(oldComponentFullyQualifiedClassName, newComponent);
    }

    public void parse(InhabitantsScanner scanner, Holder<ClassLoader> classLoader) throws IOException {
        for (KeyValuePairParser kvpp : scanner) {
            MultiMap<String, String> metadata = InhabitantsParser.buildMetadata(kvpp);
            String typeName = metadata.getOne("class");
            if (this.replacements.containsKey(typeName)) {
                Class target = this.replacements.get(typeName);
                if (target == null) continue;
                metadata.set("class", target.getName());
                Inhabitant i = Inhabitants.create(target, this.habitat, metadata);
                this.add(i, kvpp);
                this.habitat.addIndex(i, typeName, null);
                continue;
            }
            LazyInhabitant i = new LazyInhabitant(this.habitat, classLoader, typeName, metadata);
            this.add(i, kvpp);
        }
    }

    protected void add(Inhabitant i, KeyValuePairParser kvpp) {
        this.habitat.add(i);
        for (String v : kvpp.findAll("index")) {
            int idx = v.indexOf(58);
            if (idx == -1) {
                this.habitat.addIndex(i, v, null);
                continue;
            }
            String contract = v.substring(0, idx);
            String name = v.substring(idx + 1);
            this.habitat.addIndex(i, contract, name);
        }
    }

    public static MultiMap<String, String> buildMetadata(KeyValuePairParser kvpp) {
        MultiMap<String, String> metadata = new MultiMap<String, String>();
        while (kvpp.hasNext()) {
            String v;
            int idx;
            kvpp.parseNext();
            if (kvpp.getKey().equals("index") && (idx = (v = kvpp.getValue()).indexOf(58)) != -1) {
                String contract = v.substring(0, idx);
                String name = v.substring(idx + 1);
                metadata.add(contract, name);
            }
            metadata.add(kvpp.getKey(), kvpp.getValue());
        }
        return metadata;
    }
}

