/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.XAParticipant;
import com.sun.messaging.bridge.service.jms.tx.log.BranchXidDecision;
import com.sun.messaging.bridge.service.jms.tx.log.GlobalXidDecision;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRecord
implements Externalizable {
    private GlobalXidDecision _gxidd = null;
    private BranchXidDecision[] _bxidds = null;

    public LogRecord() {
    }

    public LogRecord(GlobalXid globalXid, Collection<XAParticipant> collection, int n) throws Exception {
        this._gxidd = new GlobalXidDecision(globalXid, n);
        this._bxidds = new BranchXidDecision[collection.size()];
        XAParticipant xAParticipant = null;
        Iterator<XAParticipant> iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            xAParticipant = iterator.next();
            this._bxidds[n2] = new BranchXidDecision(xAParticipant.getBranchXid(), n);
            ++n2;
        }
    }

    public GlobalXid getGlobalXid() {
        return this._gxidd.getGlobalXid();
    }

    public int getGlobalDecision() {
        return this._gxidd.getGlobalDecision();
    }

    public BranchXidDecision[] getBranchXidDecisions() {
        return this._bxidds;
    }

    public int getBranchCount() {
        return this._bxidds.length;
    }

    public void setBranchHeurCommit(BranchXid branchXid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals(branchXid)) continue;
            this._bxidds[i].setBranchDecision(50);
        }
        throw new NoSuchElementException("Branch " + branchXid + " not found in " + this._gxidd);
    }

    public void setBranchHeurRollback(BranchXid branchXid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals(branchXid)) continue;
            this._bxidds[i].setBranchDecision(51);
        }
        throw new NoSuchElementException("Branch " + branchXid + " not found in " + this._gxidd);
    }

    public void setBranchHeurMixed(BranchXid branchXid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals(branchXid)) continue;
            this._bxidds[i].setBranchDecision(52);
        }
        throw new NoSuchElementException("Branch " + branchXid + " not found in " + this._gxidd);
    }

    public boolean isHeuristicBranch(BranchXid branchXid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals(branchXid)) continue;
            return this._bxidds[i].isHeuristic() || this._bxidds[i].getBranchDecision() != this._gxidd.getGlobalDecision();
        }
        throw new NoSuchElementException("Branch " + branchXid + " not found in global transaction " + this._gxidd);
    }

    public int getBranchDecision(BranchXid branchXid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals(branchXid)) continue;
            return this._bxidds[i].getBranchDecision();
        }
        throw new NoSuchElementException("Branch " + branchXid + " not found in " + this._gxidd);
    }

    public void setBranchDecision(BranchXid branchXid, int n) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals(branchXid)) continue;
            this._bxidds[i].setBranchDecision(n);
        }
        throw new NoSuchElementException("Branch " + branchXid + " not found in " + this._gxidd);
    }

    protected void updateClientDataFromBranch(byte[] byArray, BranchXid branchXid) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            if (!this._bxidds[i].getBranchXid().equals(branchXid)) continue;
            byArray[i] = (byte)this._bxidds[i].getBranchDecision();
        }
        throw new NoSuchElementException("Branch " + branchXid + " not found in global transaction " + this._gxidd);
    }

    protected void updateBranchFromClientData(byte[] byArray) throws Exception {
        for (int i = 0; i < this._bxidds.length; ++i) {
            this._bxidds[i].setBranchDecision(byArray[i]);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this._gxidd);
        objectOutput.writeObject(this._bxidds);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._gxidd = (GlobalXidDecision)objectInput.readObject();
        this._bxidds = (BranchXidDecision[])objectInput.readObject();
        for (int i = 0; i < this._bxidds.length; ++i) {
            this._bxidds[i].getBranchXid().setFormatId(this._gxidd.getGlobalXid().getFormatId());
            this._bxidds[i].getBranchXid().setGlobalTransactionId(this._gxidd.getGlobalXid().getGlobalTransactionId());
        }
    }

    public byte[] toBytes() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (n = 0; n < this._bxidds.length; ++n) {
            if (n == 0) {
                stringBuffer.append("[");
            }
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this._bxidds[n].toString());
            stringBuffer.append(this._bxidds[n].toString());
        }
        if (n > 0) {
            stringBuffer.append("]");
        }
        return this._gxidd.toString() + stringBuffer.toString();
    }
}

