/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class CheckpointManager
implements Runnable {
    TransactionLogManager transactionLogManager;
    private BlockingQueue<Checkpoint> checkpointQueue = new ArrayBlockingQueue<Checkpoint>(5);
    int numCheckpoints;
    private Thread runner;
    public static final Logger logger = Globals.getLogger();

    CheckpointManager(TransactionLogManager transactionLogManager) {
        this.transactionLogManager = transactionLogManager;
    }

    String getPrefix() {
        return "CheckpointManager: " + Thread.currentThread().getName();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Checkpoint checkpoint = this.checkpointQueue.take();
                    this.transactionLogManager.doCheckpoint();
                }
            }
            catch (Throwable throwable) {
                logger.logStack(32, "exception when doing checkpoint", throwable);
                continue;
            }
            break;
        }
    }

    public synchronized void enqueueCheckpoint() {
        Object object;
        if (this.runner == null) {
            if (Store.getDEBUG()) {
                object = this.getPrefix() + " starting checkpoint runner";
                logger.log(4, (String)object);
            }
            this.runner = new Thread((Runnable)this, "Checkpoint runner");
            this.runner.setDaemon(true);
            this.runner.start();
        }
        object = new Checkpoint();
        int n = this.checkpointQueue.size();
        if (n > 0) {
            logger.log(32, "enqueued checkpoint request " + this.numCheckpoints + " when there are still " + n + " request(s) in process");
        }
        try {
            this.checkpointQueue.put((Checkpoint)object);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        ++this.numCheckpoints;
    }

    public class Checkpoint {
    }
}

