/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ProducerUtil {
    private static CompositeType monitorCompType = null;

    public static ConnectionUID getConnectionUID(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        if (producer == null) {
            return null;
        }
        ConnectionUID connectionUID = producer.getConnectionUID();
        return connectionUID;
    }

    public static String[] getProducerIDs() {
        int n = Producer.getNumProducers();
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Iterator iterator = Producer.getAllProducers();
        int n2 = 0;
        while (iterator.hasNext()) {
            Producer producer = (Producer)iterator.next();
            long l = producer.getProducerUID().longValue();
            stringArray[n2] = Long.toString(l);
            ++n2;
        }
        return stringArray;
    }

    public static CompositeData[] getProducerInfo() throws BrokerException, OpenDataException {
        String[] stringArray = ProducerUtil.getProducerIDs();
        if (stringArray == null) {
            return null;
        }
        CompositeData[] compositeDataArray = new CompositeData[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            compositeDataArray[i] = ProducerUtil.getProducerInfo(stringArray[i]);
        }
        return compositeDataArray;
    }

    public static CompositeData getProducerInfo(String string) throws BrokerException, OpenDataException {
        CompositeData compositeData = null;
        ProducerUID producerUID = null;
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (string == null) {
            throw new IllegalArgumentException(brokerResources.getString("B4266"));
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(brokerResources.getString("B4267", string));
        }
        producerUID = new ProducerUID(l);
        if (producerUID == null) {
            throw new BrokerException(brokerResources.getString("B4268", string));
        }
        compositeData = ProducerUtil.getProducerInfo(producerUID);
        return compositeData;
    }

    public static String getConnectionID(ProducerUID producerUID) {
        ConnectionUID connectionUID = ProducerUtil.getConnectionUID(producerUID);
        if (connectionUID == null) {
            return null;
        }
        return Long.toString(connectionUID.longValue());
    }

    public static String getDestinationName(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        if (producer != null) {
            DestinationUID destinationUID = producer.getDestinationUID();
            if (destinationUID == null) {
                return null;
            }
            return destinationUID.getName();
        }
        return null;
    }

    private static String[] getDestinationNames(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        String[] stringArray = null;
        if (producer == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = producer.getDestinations();
        for (Destination destination : set) {
            arrayList.add(destination.getDestinationName());
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public static String getDestinationType(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        if (producer != null) {
            DestinationUID destinationUID = producer.getDestinationUID();
            Destination destination = Destination.getDestination(producer.getDestinationUID());
            if (destination == null) {
                return null;
            }
            return destination.isQueue() ? "q" : "t";
        }
        return null;
    }

    public static Boolean getFlowPaused(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        if (producer == null) {
            return null;
        }
        return new Boolean(producer.isPaused());
    }

    public static String getHost(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        ConnectionUID connectionUID = null;
        if (producer == null) {
            return null;
        }
        connectionUID = producer.getConnectionUID();
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(connectionUID.longValue());
        if (connectionInfo == null) {
            return null;
        }
        String string = null;
        if (connectionInfo.remoteIP != null) {
            string = String.valueOf(IPAddress.rawIPToString(connectionInfo.remoteIP, true, true));
        }
        return string;
    }

    public static Long getCreationTime(ProducerUID producerUID) {
        long l = System.currentTimeMillis();
        return new Long(l - producerUID.age(l));
    }

    public static Long getNumMsgs(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        if (producer == null) {
            return null;
        }
        return new Long(producer.getMsgCnt());
    }

    public static String getServiceName(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        ConnectionUID connectionUID = null;
        if (producer == null) {
            return null;
        }
        connectionUID = producer.getConnectionUID();
        if (connectionUID == null) {
            return null;
        }
        return ConnectionUtil.getServiceOfConnection(connectionUID.longValue());
    }

    public static String getUser(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        ConnectionUID connectionUID = null;
        if (producer == null) {
            return null;
        }
        connectionUID = producer.getConnectionUID();
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = ConnectionUtil.getConnectionInfo(connectionUID.longValue());
        return connectionInfo.user;
    }

    public static boolean isWildcard(ProducerUID producerUID) {
        Producer producer = Producer.getProducer(producerUID);
        if (producer != null) {
            return producer.isWildcard();
        }
        return false;
    }

    private static Boolean getWildcard(ProducerUID producerUID) {
        return new Boolean(ProducerUtil.isWildcard(producerUID));
    }

    private static CompositeData getProducerInfo(ProducerUID producerUID) throws OpenDataException {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"ConnectionID", "CreationTime", "DestinationName", "DestinationNames", "DestinationType", "FlowPaused", "Host", "NumMsgs", "ProducerID", "ServiceName", "User", "Wildcard"};
        OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN};
        Object[] objectArray = new Object[]{ProducerUtil.getConnectionID(producerUID), ProducerUtil.getCreationTime(producerUID), ProducerUtil.getDestinationName(producerUID), ProducerUtil.getDestinationNames(producerUID), ProducerUtil.getDestinationType(producerUID), ProducerUtil.getFlowPaused(producerUID), ProducerUtil.getHost(producerUID), ProducerUtil.getNumMsgs(producerUID), Long.toString(producerUID.longValue()), ProducerUtil.getServiceName(producerUID), ProducerUtil.getUser(producerUID), ProducerUtil.getWildcard(producerUID)};
        CompositeDataSupport compositeDataSupport = null;
        if (monitorCompType == null) {
            monitorCompType = new CompositeType("ProducerMonitorInfo", "ProducerMonitorInfo", stringArray, stringArray2, openTypeArray);
        }
        compositeDataSupport = new CompositeDataSupport(monitorCompType, stringArray, objectArray);
        return compositeDataSupport;
    }
}

