/*
 * Decompiled with CFR 0.152.
 */
package jmaki.xhp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jmaki.xhp.HttpClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class XmlHttpProxy {
    public static String GET = "GET";
    public static String POST = "POST";
    public static String DELETE = "DELETE";
    public static String PUT = "PUT";
    private String userName = null;
    private String password = null;
    private static Logger logger;
    private String proxyHost = "";
    int proxyPort = -1;
    private JSONObject config;
    private static String USAGE;

    public XmlHttpProxy() {
    }

    public XmlHttpProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public XmlHttpProxy(String proxyHost, int proxyPort, String userName, String password) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.userName = userName;
        this.password = password;
    }

    public void processRequest(String urlString, OutputStream out, InputStream xslInputStream, Map paramsMap, Map headers, String method, String userName, String password) throws IOException, MalformedURLException {
        this.doProcess(urlString, out, xslInputStream, paramsMap, headers, method, null, null, userName, password);
    }

    public void doPost(String urlString, OutputStream out, InputStream xslInputStream, Map paramsMap, Map headers, String postData, String postContentType, String userName, String password) throws IOException, MalformedURLException {
        this.doProcess(urlString, out, xslInputStream, paramsMap, headers, POST, postData, postContentType, userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcess(String urlString, OutputStream out, InputStream xslInputStream, Map paramsMap, Map headers, String method, String postData, String postContentType, String userName, String password) throws IOException, MalformedURLException {
        block19: {
            String format;
            if (paramsMap == null) {
                paramsMap = new HashMap();
            }
            if ((format = (String)paramsMap.get("format")) == null) {
                format = "xml";
            }
            InputStream in = null;
            Object os = null;
            HttpClient httpclient = null;
            httpclient = userName != null && password != null ? new HttpClient(this.proxyHost, this.proxyPort, urlString, headers, method, userName, password) : new HttpClient(this.proxyHost, this.proxyPort, urlString, headers, method);
            in = postData == null ? httpclient.getInputStream() : httpclient.doPost(postData, postContentType);
            String ce = httpclient.getContentEncoding();
            if (ce == null) {
                int idx;
                String ct = httpclient.getContentType();
                ce = ct != null ? ((idx = ct.lastIndexOf("charset=")) >= 0 ? ct.substring(idx + 8) : "UTF-8") : "UTF-8";
            }
            String cType = null;
            cType = format.equals("json") ? "application/json;charset=" + ce : "text/xml;charset=" + ce;
            try {
                byte[] buffer = new byte[1024];
                int read = 0;
                if (xslInputStream == null) {
                    while (true) {
                        if ((read = in.read(buffer)) <= 0) {
                            break block19;
                        }
                        out.write(buffer, 0, read);
                    }
                }
                this.transform(in, xslInputStream, paramsMap, out, ce);
            }
            catch (Exception e) {
                XmlHttpProxy.getLogger().severe("XmlHttpProxy transformation error: " + e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void transform(InputStream xmlIS, InputStream xslIS, Map params, OutputStream result, String encoding) {
        try {
            TransformerFactory trFac = TransformerFactory.newInstance();
            Transformer transformer = trFac.newTransformer(new StreamSource(xslIS));
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                transformer.setParameter(key, (String)params.get(key));
            }
            transformer.setOutputProperty("encoding", encoding);
            transformer.transform(new StreamSource(xmlIS), new StreamResult(result));
        }
        catch (Exception e) {
            XmlHttpProxy.getLogger().severe("XmlHttpProxy: Exception with xslt " + e);
        }
    }

    public static void main(String[] args) throws IOException, MalformedURLException {
        XmlHttpProxy.getLogger().info("XmlHttpProxy 1.8");
        XmlHttpProxy xhp = new XmlHttpProxy();
        if (args.length == 0) {
            System.out.println(USAGE);
        }
        String method = GET;
        InputStream xslInputStream = null;
        String serviceKey = null;
        String urlString = null;
        String xslURLString = null;
        String format = "xml";
        String callback = null;
        String urlParams = null;
        String configURLString = "xhp.json";
        String resourceBase = "file:src/conf/META-INF/resources/xsl/";
        String username = null;
        String password = null;
        for (int index = 0; index < args.length; ++index) {
            if (args[index].toLowerCase().equals("-url") && index + 1 < args.length) {
                urlString = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-key") && index + 1 < args.length) {
                serviceKey = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-id") && index + 1 < args.length) {
                serviceKey = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-callback") && index + 1 < args.length) {
                callback = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-xslurl") && index + 1 < args.length) {
                xslURLString = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-method") && index + 1 < args.length) {
                method = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-username") && index + 1 < args.length) {
                username = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-password") && index + 1 < args.length) {
                password = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-urlparams") && index + 1 < args.length) {
                urlParams = args[++index];
                continue;
            }
            if (args[index].toLowerCase().equals("-config") && index + 1 < args.length) {
                configURLString = args[++index];
                continue;
            }
            if (!args[index].toLowerCase().equals("-resources") || index + 1 >= args.length) continue;
            resourceBase = args[++index];
        }
        if (serviceKey != null) {
            try {
                InputStream is = new URL(configURLString).openStream();
                JSONObject services = XmlHttpProxy.loadServices(is);
                JSONObject service = services.getJSONObject(serviceKey);
                if (urlParams == null && service.has("defaultURLParams")) {
                    urlParams = service.getString("defaultURLParams");
                }
                String serviceURL = service.getString("url");
                if (urlParams != null && serviceURL.indexOf("?") == -1) {
                    serviceURL = serviceURL + "?";
                } else if (urlParams != null) {
                    serviceURL = serviceURL + "&";
                }
                String apiKey = "";
                if (service.has("apikey")) {
                    apiKey = service.getString("apikey");
                }
                urlString = serviceURL + apiKey + "&" + urlParams;
                if (service.has("xslStyleSheet")) {
                    xslURLString = service.getString("xslStyleSheet");
                }
            }
            catch (Exception ex) {
                XmlHttpProxy.getLogger().severe("XmlHttpProxy Error loading service: " + ex);
                System.exit(1);
            }
        } else if (urlString == null) {
            System.out.println(USAGE);
            System.exit(1);
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (format != null) {
            paramsMap.put("format", format);
        }
        if (callback != null) {
            paramsMap.put("callback", callback);
        }
        if (xslURLString != null) {
            URL xslURL = new URL(xslURLString);
            if (xslURL != null) {
                xslInputStream = xslURL.openStream();
            } else {
                XmlHttpProxy.getLogger().severe("Error: Unable to locate XSL at URL " + xslURLString);
            }
        }
        xhp.processRequest(urlString, System.out, xslInputStream, paramsMap, null, method, username, password);
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("jmaki.xhp.Log");
        }
        return logger;
    }

    public static JSONObject loadServices(InputStream is) {
        JSONObject config = null;
        JSONObject services = new JSONObject();
        try {
            config = XmlHttpProxy.loadJSONObject(is).getJSONObject("xhp");
            JSONArray sA = config.getJSONArray("services");
            for (int l = 0; l < sA.length(); ++l) {
                JSONObject value = sA.getJSONObject(l);
                String key = value.getString("id");
                services.put(key, (Object)value);
            }
        }
        catch (Exception ex) {
            XmlHttpProxy.getLogger().severe("XmlHttpProxy error loading services." + ex);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject loadJSONObject(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            out = new ByteArrayOutputStream();
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            JSONObject jSONObject = new JSONObject(out.toString());
            return jSONObject;
        }
        catch (Exception e) {
            XmlHttpProxy.getLogger().severe("XmlHttpProxy error reading in json " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    static {
        USAGE = "Usage:  -url service_URL  -id service_key [-url or -id required] -xslurl xsl_url [optional] -format json|xml [optional] -callback[optional] -config [optional] -resources base_directory_containing XSL stylesheets [optional]";
    }
}

