/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import jmaki.runtime.CombinedResourceManager;

public class CombinedResource {
    byte[] gzippedContent;
    StringBuffer content;
    String contentType;
    long created;
    long maxAge;
    String expires;
    String hash;
    String contentHash;

    public CombinedResource(String contentType, long maxAge, String hash) {
        this.contentType = contentType;
        this.maxAge = maxAge;
        this.content = new StringBuffer();
        this.hash = hash;
        this.resetTime();
    }

    public void reset() {
        this.content = new StringBuffer();
        this.gzippedContent = null;
        this.resetTime();
    }

    public void resetTime() {
        this.created = System.currentTimeMillis();
        Date expiredate = new Date(this.created + this.maxAge * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss  z");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.expires = sdf.format(expiredate);
    }

    public boolean isExpired() {
        long current = System.currentTimeMillis();
        long diff = current - this.created;
        return diff / 1000L > this.maxAge;
    }

    public long getMaxAge() {
        long current = System.currentTimeMillis();
        long diff = current + this.maxAge * 1000L - this.created;
        return diff / 1000L;
    }

    public String getExpires() {
        return this.expires;
    }

    public long getContentLegth() {
        if (this.content == null) {
            return 0L;
        }
        return this.content.length();
    }

    public String getContentType() {
        return this.contentType;
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public void appendContent(String ncontent) {
        this.content.append(ncontent);
    }

    public String getHash() {
        return this.hash;
    }

    public byte[] getGZippedContent() {
        if (this.gzippedContent == null && this.getContent() != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.getContent().toString().getBytes());
            try {
                int read;
                GZIPOutputStream out = new GZIPOutputStream(bos);
                byte[] buffer = new byte[1024];
                while ((read = bis.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                bis.close();
                out.finish();
                out.close();
                this.gzippedContent = bos.toByteArray();
            }
            catch (IOException ioe) {
                System.err.println("CombinedResource exception : " + ioe);
                ioe.printStackTrace();
            }
        }
        return this.gzippedContent;
    }

    public String getContentHash() {
        if (this.contentHash == null) {
            this.contentHash = CombinedResourceManager.generateHash(this.content.toString());
        }
        return this.contentHash;
    }
}

