/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileAction
extends Action {
    Image img;
    String path = "";
    String owner = "";
    String group = "";
    String mode = "";

    AbstractFileAction(int k, Image image, String[] tokens) {
        super(k);
        this.img = image;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].startsWith("owner=")) {
                this.owner = tokens[i].substring(6);
                continue;
            }
            if (tokens[i].startsWith("path=")) {
                this.path = tokens[i].substring(5);
                continue;
            }
            if (tokens[i].startsWith("mode=")) {
                this.mode = tokens[i].substring(5);
                continue;
            }
            if (!tokens[i].startsWith("group=")) continue;
            this.group = tokens[i].substring(6);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    void remove() throws IOException {
        File target = new File(this.img.getRootDirectory(), this.path);
        this.setPermissions(target, "0644");
        target.delete();
    }

    @Override
    String keyValue() {
        return this.path;
    }

    @Override
    List<String> getReferencedDirectories() {
        ArrayList<String> l = new ArrayList<String>();
        for (File parent = new File(this.path).getParentFile(); parent != null; parent = parent.getParentFile()) {
            l.add(parent.toString());
        }
        return l;
    }
}

