/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import java.util.Collection;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.extras.osgicontainer.OSGiArchiveHandler;
import org.glassfish.extras.osgicontainer.OSGiContainer;
import org.glassfish.extras.osgicontainer.OSGiDeployedBundle;
import org.glassfish.extras.osgicontainer.RefCountingClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class OSGiDeployer
implements Deployer<OSGiContainer, OSGiDeployedBundle> {
    @Inject
    ModulesRegistry registry;
    @Inject
    OSGiArchiveHandler archiveHandler;

    public OSGiDeployedBundle load(OSGiContainer container, DeploymentContext context) {
        Module module;
        Collection<Module> modules = this.registry.getModules(context.getAppProps().getProperty("module-name"));
        Module module2 = module = modules.size() > 0 ? modules.iterator().next() : null;
        if (module == null) {
            throw new RuntimeException("Cannot install OSGi bundle in repository, is this an OSGi bundle ?");
        }
        RefCountingClassLoader loader = this.archiveHandler.getClassLoader(null, module);
        if (context.getFinalClassLoader() instanceof PreDestroy) {
            ((PreDestroy)((Object)context.getFinalClassLoader())).preDestroy();
        }
        return new OSGiDeployedBundle(module, loader);
    }

    public void unload(OSGiDeployedBundle appContainer, DeploymentContext context) {
        appContainer.cl.preDestroy();
        context.addModuleMetaData((Object)appContainer.m);
    }

    public void clean(DeploymentContext context) {
        Module m;
        OpsParams params = context.getCommandParameters(OpsParams.class);
        if (params != null && params.origin == OpsParams.Origin.undeploy && (m = (Module)context.getModuleMetaData(Module.class)) != null && m.getState() != ModuleState.NEW) {
            m.uninstall();
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        return true;
    }
}

