/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.portunif;

import com.sun.grizzly.Context;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.buf.Ascii;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class HttpRedirector {
    private static final String NEWLINE = "\r\n";
    private static String ipAddress = "127.0.0.1";
    private static final String headers = "\r\nConnection:close\r\nCache-control: private\r\n\r\n";
    private static final ByteBuffer SC_FOUND;

    private HttpRedirector() {
    }

    public static final void redirectSSL(Context context, PUProtocolRequest protocolRequest) throws IOException {
        HttpRedirector.redirectSSL(context, protocolRequest, false);
    }

    public static final void redirectSSL(Context context, PUProtocolRequest protocolRequest, boolean redirectToSecure) throws IOException {
        HttpRedirector.redirectSSL(context, protocolRequest.getSSLEngine(), protocolRequest.getByteBuffer(), protocolRequest.getSecuredOutputByteBuffer(), redirectToSecure);
    }

    public static final void redirectSSL(Context context, SSLEngine sslEngine, ByteBuffer byteBuffer, ByteBuffer outputBB, boolean redirectToSecure) throws IOException {
        String host = HttpRedirector.parseHost(byteBuffer);
        if (host == null) {
            host = ipAddress + ":" + ((SocketChannel)context.getSelectionKey().channel()).socket().getLocalPort();
        }
        HttpRedirector.redirectSSL(context, sslEngine, outputBB, redirectToSecure ? new String("Location: https://" + host) : new String("Location: http://" + host));
    }

    private static final void redirectSSL(Context context, SSLEngine sslEngine, ByteBuffer outputBB, String httpHeaders) throws IOException {
        SelectableChannel channel = context.getSelectionKey().channel();
        SSLOutputWriter.flushChannel((SelectableChannel)channel, (ByteBuffer)SC_FOUND.slice(), (ByteBuffer)outputBB, (SSLEngine)sslEngine);
        SSLOutputWriter.flushChannel((SelectableChannel)channel, (ByteBuffer)ByteBuffer.wrap((httpHeaders + new String((byte[])context.getAttribute("HTTP_REQUEST_URL")) + headers).getBytes()), (ByteBuffer)outputBB, (SSLEngine)sslEngine);
    }

    public static final void redirect(Context context, PUProtocolRequest protocolRequest) throws IOException {
        HttpRedirector.redirect(context, protocolRequest, true);
    }

    public static final void redirect(Context context, PUProtocolRequest protocolRequest, boolean redirectToSecure) throws IOException {
        HttpRedirector.redirect(context, protocolRequest.getByteBuffer(), redirectToSecure);
    }

    public static final void redirect(Context context, ByteBuffer byteBuffer, boolean redirectToSecure) throws IOException {
        String host = HttpRedirector.parseHost(byteBuffer);
        if (host == null) {
            host = ipAddress + ":" + ((SocketChannel)context.getSelectionKey().channel()).socket().getLocalPort();
        }
        HttpRedirector.redirect(context, redirectToSecure ? new String("Location: https://" + host) : new String("Location: http://" + host));
    }

    private static final void redirect(Context context, String httpHeaders) throws IOException {
        SelectableChannel channel = context.getSelectionKey().channel();
        OutputWriter.flushChannel((SelectableChannel)channel, (ByteBuffer)SC_FOUND.slice());
        OutputWriter.flushChannel((SelectableChannel)channel, (ByteBuffer)ByteBuffer.wrap((httpHeaders + new String((byte[])context.getAttribute("HTTP_REQUEST_URL")) + headers).getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String parseHost(ByteBuffer byteBuffer) {
        boolean isFound = false;
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            return ipAddress;
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        int state = 0;
        int start = 0;
        int end = 0;
        try {
            block14: while (byteBuffer.hasRemaining()) {
                byte c = (byte)Ascii.toLower((int)byteBuffer.get());
                switch (state) {
                    case 0: {
                        if (c == 104) {
                            state = 1;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 1: {
                        if (c == 111) {
                            state = 2;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 2: {
                        if (c == 115) {
                            state = 3;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 3: {
                        if (c == 116) {
                            state = 4;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 4: {
                        if (c == 58) {
                            state = 5;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 5: {
                        StringBuilder sb = new StringBuilder();
                        while (c != 13 && c != 10) {
                            sb.append((char)c);
                            c = byteBuffer.get();
                        }
                        String string = sb.toString().trim();
                        return string;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            String string = null;
            return string;
        }
        catch (BufferUnderflowException bue) {
            String string = null;
            return string;
        }
        finally {
            if (end > 0) {
                byteBuffer.position(start);
                byteBuffer.limit(end);
            } else {
                byteBuffer.limit(curLimit);
                byteBuffer.position(curPosition);
            }
        }
    }

    private static void log(Throwable ex) {
        Logger logger = SSLSelectorThread.logger();
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Redirector", ex);
        }
    }

    static {
        try {
            ipAddress = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SC_FOUND = ByteBuffer.wrap("HTTP/1.1 302 Moved Temporarily\r\n".getBytes());
    }
}

