/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.logging.Logger;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.util.FiberExecutor;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public final class Communicator {
    private static final Logger LOGGER = Logger.getLogger(Communicator.class);
    public final QName soapMustUnderstandAttributeName;
    private final SecureConversationInitiator scInitiator;
    private FiberExecutor fiberExecutor;
    private final EndpointAddress destinationAddress;
    private final AddressingVersion addressingVersion;
    private final SOAPVersion soapVersion;
    private final JAXBRIContext jaxbContext;

    public Communicator(String name, EndpointAddress destinationAddress, Tube tubeline, SecureConversationInitiator scInitiator, AddressingVersion addressingVersion, SOAPVersion soapVersion, JAXBRIContext jaxbContext) {
        this.destinationAddress = destinationAddress;
        this.fiberExecutor = new FiberExecutor(name, tubeline);
        this.scInitiator = scInitiator;
        this.addressingVersion = addressingVersion;
        this.soapVersion = soapVersion;
        this.soapMustUnderstandAttributeName = new QName(soapVersion.nsUri, "mustUnderstand");
        this.jaxbContext = jaxbContext;
    }

    public final Packet createRequestPacket(Object jaxbElement, String wsaAction, boolean expectReply) {
        Message message = Messages.create(this.jaxbContext, jaxbElement, this.soapVersion);
        return this.createRequestPacket(message, wsaAction, expectReply);
    }

    public final Packet createRequestPacket(Message message, String wsaAction, boolean expectReply) {
        Packet packet = new Packet(message);
        packet.endpointAddress = this.destinationAddress;
        packet.expectReply = expectReply;
        message.getHeaders().fillRequestAddressingHeaders(packet, this.addressingVersion, this.soapVersion, !expectReply, wsaAction);
        return packet;
    }

    public final Packet createRequestPacket(Packet originalRequestPacket, Object jaxbElement, String wsaAction, boolean expectReply) {
        if (originalRequestPacket != null) {
            return this.createResponsePacket(originalRequestPacket, jaxbElement, wsaAction);
        }
        Message message = Messages.create(this.jaxbContext, jaxbElement, this.soapVersion);
        return this.createRequestPacket(message, wsaAction, expectReply);
    }

    public Packet createEmptyRequestPacket(boolean expectReply) {
        Packet packet = new Packet();
        packet.endpointAddress = this.destinationAddress;
        packet.expectReply = expectReply;
        return packet;
    }

    public Packet createEmptyRequestPacket(String requestWsaAction, boolean expectReply) {
        return this.createRequestPacket(Messages.createEmpty(this.soapVersion), requestWsaAction, expectReply);
    }

    public Packet createResponsePacket(Packet requestPacket, Object jaxbElement, String responseWsaAction) {
        if (requestPacket != null) {
            return requestPacket.createServerResponse(Messages.create(this.jaxbContext, jaxbElement, this.soapVersion), this.addressingVersion, this.soapVersion, responseWsaAction);
        }
        return this.createRequestPacket(jaxbElement, responseWsaAction, false);
    }

    public Packet createResponsePacket(Packet requestPacket, Message message, String responseWsaAction) {
        if (requestPacket != null) {
            return requestPacket.createServerResponse(message, this.addressingVersion, this.soapVersion, responseWsaAction);
        }
        return this.createRequestPacket(message, responseWsaAction, false);
    }

    public Packet createEmptyResponsePacket(Packet requestPacket, String responseWsaAction) {
        return requestPacket.createServerResponse(Messages.createEmpty(this.soapVersion), this.addressingVersion, this.soapVersion, responseWsaAction);
    }

    public Packet createNullResponsePacket(Packet requestPacket) {
        if (requestPacket.transportBackChannel != null) {
            requestPacket.transportBackChannel.close();
        }
        Packet emptyReturnPacket = new Packet();
        emptyReturnPacket.invocationProperties.putAll(requestPacket.invocationProperties);
        return emptyReturnPacket;
    }

    public final Packet setEmptyRequestMessage(Packet request, String wsaAction) {
        Message message = Messages.createEmpty(this.soapVersion);
        request.setMessage(message);
        message.getHeaders().fillRequestAddressingHeaders(request, this.addressingVersion, this.soapVersion, false, wsaAction);
        return request;
    }

    public final Packet setEmptyResponseMessage(Packet response, Packet request, String wsaAction) {
        Message message = Messages.createEmpty(this.soapVersion);
        response.setResponseMessage(request, message, this.addressingVersion, this.soapVersion, wsaAction);
        return response;
    }

    public String getWsaAction(Packet packet) {
        if (packet == null || packet.getMessage() == null) {
            return null;
        }
        return packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
    }

    public String getWsaTo(Packet packet) {
        if (packet == null || packet.getMessage() == null) {
            return null;
        }
        return packet.getMessage().getHeaders().getTo(this.addressingVersion, this.soapVersion);
    }

    public SecurityTokenReferenceType tryStartSecureConversation(Packet request) {
        SecurityTokenReferenceType strType = null;
        if (this.scInitiator != null) {
            try {
                Packet emptyPacket = this.createEmptyRequestPacket(false);
                emptyPacket.invocationProperties.putAll(request.invocationProperties);
                JAXBElement strElement = this.scInitiator.startSecureConversation(emptyPacket);
                strType = strElement != null ? (SecurityTokenReferenceType)strElement.getValue() : null;
            }
            catch (WSSecureConversationException ex) {
                LOGGER.severe(LocalizationMessages.WSRM_1121_SECURE_CONVERSATION_INIT_FAILED(), (Throwable)ex);
            }
        }
        return strType;
    }

    public Packet send(Packet request) {
        request.expectReply = Boolean.TRUE;
        return this.fiberExecutor.runSync(request);
    }

    public void sendAsync(Packet request, Fiber.CompletionCallback completionCallbackHandler) {
        this.fiberExecutor.start(request, completionCallbackHandler);
    }

    public EndpointAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public SOAPVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void close() {
        FiberExecutor fe = this.fiberExecutor;
        if (fe != null) {
            this.fiberExecutor.close();
            this.fiberExecutor = null;
        }
    }
}

