/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIObjectCache;
import com.sun.xml.registry.uddi.infomodel.ExtensibleObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;

public abstract class RegistryObjectImpl
extends ExtensibleObjectImpl
implements RegistryObject,
Serializable {
    ArrayList associations = new ArrayList();
    ArrayList classifications = new ArrayList();
    ArrayList externalIdentifiers = new ArrayList();
    ArrayList externalLinks = new ArrayList();
    InternationalString description = new InternationalStringImpl();
    InternationalString name = new InternationalStringImpl();
    Key key;
    Organization submittingOrganization;
    LifeCycleManager lifeCycleManager;
    transient boolean isRetrieved = false;
    transient boolean isLoaded = false;
    transient boolean isNew = true;
    transient boolean isModified = false;
    transient boolean isDeleted = false;
    transient String serviceId;
    RegistryService registryService;
    transient boolean areAssociationsLoaded = false;
    UDDIObjectCache objectManager;

    public RegistryObjectImpl() {
    }

    public RegistryObjectImpl(Key key) {
        this();
        this.key = key;
    }

    public RegistryObjectImpl(Key key, String string2, String string3) {
        this(key);
        this.description = new InternationalStringImpl(string2);
        this.name = new InternationalStringImpl(string3);
    }

    @Override
    public void addSlot(Slot slot) throws JAXRException {
        super.addSlot(slot);
        this.setIsModified(true);
    }

    @Override
    public void addSlots(Collection collection) throws JAXRException {
        super.addSlots(collection);
        this.setIsModified(true);
    }

    @Override
    public void removeSlot(String string2) throws JAXRException {
        super.removeSlot(string2);
        this.setIsModified(true);
    }

    @Override
    public void removeSlots(Collection collection) throws JAXRException {
        super.removeSlots(collection);
        this.setIsModified(true);
    }

    @Override
    public void addAssociation(Association association) throws JAXRException {
        if (association == null) {
            return;
        }
        association.setSourceObject(this);
        this.associations.add(association);
        this.setIsModified(true);
    }

    @Override
    public void addAssociations(Collection collection) throws JAXRException {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                this.addAssociation((Association)iterator.next());
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Objects_in_collection_must_be_Associations"), classCastException);
        }
        this.setIsModified(true);
    }

    @Override
    public void removeAssociation(Association association) throws JAXRException {
        if (association != null) {
            this.associations.remove(association);
            this.setIsModified(true);
        }
    }

    @Override
    public void removeAssociations(Collection collection) throws JAXRException {
        if (collection != null) {
            this.associations.removeAll(collection);
            this.setIsModified(true);
        }
    }

    @Override
    public Collection getAssociations() throws JAXRException {
        if (this.associations.isEmpty()) {
            if (this instanceof Organization) {
                this.getOrganizationAssociations();
            } else {
                this.getObject();
            }
        }
        return (Collection)this.associations.clone();
    }

    @Override
    public void setAssociations(Collection collection) throws JAXRException {
        this.associations.clear();
        this.addAssociations(collection);
        this.setIsModified(true);
    }

    public void setAssociationsLoaded(boolean bl) {
        this.areAssociationsLoaded = bl;
    }

    public boolean areAssociationsLoaded() {
        return this.areAssociationsLoaded;
    }

    @Override
    public void addClassification(Classification classification) throws JAXRException {
        if (classification == null) {
            return;
        }
        this.getObject();
        classification.setClassifiedObject(this);
        this.classifications.add(classification);
        this.setIsModified(true);
    }

    @Override
    public void addClassifications(Collection collection) throws JAXRException {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                this.addClassification((Classification)iterator.next());
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Objects_in_collection_must_be_Classifiations"), classCastException);
        }
        this.setIsModified(true);
    }

    @Override
    public void removeClassification(Classification classification) throws JAXRException {
        if (classification != null) {
            this.getObject();
            this.classifications.remove(classification);
            this.setIsModified(true);
        }
    }

    @Override
    public void removeClassifications(Collection collection) throws JAXRException {
        if (collection != null) {
            this.getObject();
            this.classifications.removeAll(collection);
            this.setIsModified(true);
        }
    }

    @Override
    public Collection getClassifications() throws JAXRException {
        if (this.classifications.isEmpty()) {
            this.getObject();
        }
        return (Collection)this.classifications.clone();
    }

    @Override
    public void setClassifications(Collection collection) throws JAXRException {
        this.getObject();
        this.classifications.clear();
        this.addClassifications(collection);
        this.setIsModified(true);
    }

    @Override
    public void addExternalIdentifier(ExternalIdentifier externalIdentifier) throws JAXRException {
        if (externalIdentifier == null) {
            return;
        }
        this.getObject();
        ((ExternalIdentifierImpl)externalIdentifier).setRegistryObject(this);
        this.externalIdentifiers.add(externalIdentifier);
        this.setIsModified(true);
    }

    @Override
    public void addExternalIdentifiers(Collection collection) throws JAXRException {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                this.addExternalIdentifier((ExternalIdentifier)iterator.next());
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Objects_in_collection_must_be_ExternalIdentifers"), classCastException);
        }
        this.setIsModified(true);
    }

    @Override
    public void removeExternalIdentifier(ExternalIdentifier externalIdentifier) throws JAXRException {
        if (externalIdentifier != null) {
            this.getObject();
            this.externalIdentifiers.remove(externalIdentifier);
            this.setIsModified(true);
        }
    }

    @Override
    public void removeExternalIdentifiers(Collection collection) throws JAXRException {
        if (collection != null) {
            this.getObject();
            this.externalIdentifiers.removeAll(collection);
            this.setIsModified(true);
        }
    }

    @Override
    public Collection getExternalIdentifiers() throws JAXRException {
        if (this.externalIdentifiers.isEmpty()) {
            this.getObject();
        }
        return (Collection)this.externalIdentifiers.clone();
    }

    @Override
    public void setExternalIdentifiers(Collection collection) throws JAXRException {
        this.getObject();
        this.externalIdentifiers.clear();
        this.addExternalIdentifiers(collection);
        this.setIsModified(true);
    }

    @Override
    public void addExternalLink(ExternalLink externalLink) throws JAXRException {
        throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:ExternalLinks_may_be_added_only_to_Organization,_Concept,_ClassificationScheme,_and_SpecificationLink"));
    }

    @Override
    public void addExternalLinks(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:ExternalLinks_may_be_added_only_to_Organization,_Concept,_ClassificationScheme,_and_SpecificationLink"));
    }

    @Override
    public void removeExternalLink(ExternalLink externalLink) throws JAXRException {
        if (externalLink != null) {
            this.getObject();
            this.externalLinks.remove(externalLink);
            this.setIsModified(true);
        }
    }

    @Override
    public void removeExternalLinks(Collection collection) throws JAXRException {
        if (collection != null) {
            this.getObject();
            this.externalLinks.removeAll(collection);
            this.setIsModified(true);
        }
    }

    @Override
    public Collection getExternalLinks() throws JAXRException {
        if (this.externalLinks.isEmpty()) {
            this.getObject();
        }
        return (Collection)this.externalLinks.clone();
    }

    @Override
    public void setExternalLinks(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:ExternalLinks_may_be_added_only_to_Organization,_Concept,_ClassificationScheme,_and_SpecificationLink"));
    }

    @Override
    public InternationalString getDescription() throws JAXRException {
        String string2 = this.description.getValue();
        if (string2 == null || string2.equals("")) {
            this.getObject();
        }
        return this.description;
    }

    @Override
    public void setDescription(InternationalString internationalString) throws JAXRException {
        if (internationalString != null) {
            this.getObject();
            this.description = internationalString;
        } else {
            this.description = new InternationalStringImpl();
        }
        this.setIsModified(true);
    }

    @Override
    public InternationalString getName() throws JAXRException {
        String string2 = this.name.getValue();
        if (string2 == null || string2.equals("")) {
            this.getObject();
        }
        return this.name;
    }

    @Override
    public void setName(InternationalString internationalString) throws JAXRException {
        if (internationalString != null) {
            this.getObject();
            this.name = internationalString;
        } else {
            this.name = new InternationalStringImpl();
        }
        this.setIsModified(true);
    }

    @Override
    public Key getKey() throws JAXRException {
        return this.key;
    }

    @Override
    public void setKey(Key key) throws JAXRException {
        this.key = key;
        this.setIsModified(true);
    }

    @Override
    public Organization getSubmittingOrganization() throws JAXRException {
        if (this.submittingOrganization == null) {
            this.getObject();
        }
        return this.submittingOrganization;
    }

    public void setSubmittingOrganization(Organization organization) throws JAXRException {
        this.submittingOrganization = organization;
    }

    public Connection getConnection() throws JAXRException {
        if (this.lifeCycleManager != null) {
            RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.lifeCycleManager.getRegistryService();
            return registryServiceImpl != null ? registryServiceImpl.getConnection() : null;
        }
        return null;
    }

    @Override
    public LifeCycleManager getLifeCycleManager() {
        return this.lifeCycleManager;
    }

    public void setLifeCycleManager(LifeCycleManager lifeCycleManager) {
        this.lifeCycleManager = lifeCycleManager;
    }

    public void setServiceId(String string2) {
        this.serviceId = string2;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public synchronized void setStatusFlags(boolean bl, boolean bl2, boolean bl3) {
        this.isRetrieved = bl;
        this.isLoaded = bl2;
        this.isNew = bl3;
    }

    public synchronized boolean isLoaded() {
        return this.isLoaded;
    }

    public synchronized void setIsLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    public synchronized boolean isRetrieved() {
        return this.isRetrieved;
    }

    public synchronized void setIsRetrieved(boolean bl) {
        this.isDeleted = false;
        this.isRetrieved = bl;
    }

    public synchronized boolean isNew() {
        return this.isNew;
    }

    public synchronized void setIsNew(boolean bl) {
        this.isNew = bl;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setIsModified(boolean bl) {
        this.isModified = bl;
    }

    public synchronized boolean isDeleted() {
        return this.isDeleted;
    }

    public synchronized void setIsDeleted(boolean bl) {
        this.isDeleted = bl;
    }

    void getObject() throws JAXRException {
        if (this.isDeleted()) {
            return;
        }
        if (this.isRetrieved() && !this.isLoaded()) {
            if (this.objectManager == null) {
                this.objectManager = this.getObjectManager();
            }
            if (this.objectManager == null) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryObjectImpl:Can_not_obtain_Object_detail"));
            }
            this.objectManager.fetchObject(this, this.serviceId);
        }
    }

    UDDIObjectCache getObjectManager() throws JAXRException {
        if (this.registryService == null && this.lifeCycleManager != null) {
            this.registryService = this.lifeCycleManager.getRegistryService();
        }
        if (this.registryService != null) {
            this.objectManager = ((RegistryServiceImpl)this.registryService).getObjectManager();
        }
        return this.objectManager;
    }

    void getOrganizationAssociations() throws JAXRException {
        if (this.isDeleted() || this.isNew()) {
            return;
        }
        if (this.isRetrieved() && !this.areAssociationsLoaded()) {
            if (this.objectManager == null) {
                this.objectManager = this.getObjectManager();
            }
            if (this.objectManager != null) {
                this.objectManager.fetchAssociations(this, this.serviceId);
            }
        }
    }

    int getSequenceId(ExternalLink externalLink) {
        return this.externalLinks.indexOf(externalLink);
    }

    @Override
    public String toXML() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public Collection getAssociatedObjects() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public Concept getObjectType() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void setObjectType(Concept concept) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public Collection getAuditTrail() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public Collection getRegistryPackages() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

