/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.plugins.PluginInfo;

public class PluginsAndModules
implements Writeable,
ToXContentFragment {
    private final List<PluginInfo> plugins;
    private final List<PluginInfo> modules;

    public PluginsAndModules(List<PluginInfo> plugins, List<PluginInfo> modules) {
        this.plugins = Collections.unmodifiableList(plugins);
        this.modules = Collections.unmodifiableList(modules);
    }

    public PluginsAndModules(StreamInput in) throws IOException {
        this.plugins = Collections.unmodifiableList(in.readList(PluginInfo::new));
        this.modules = Collections.unmodifiableList(in.readList(PluginInfo::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.plugins);
        out.writeList(this.modules);
    }

    public List<PluginInfo> getPluginInfos() {
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>(this.plugins);
        Collections.sort(plugins, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        return plugins;
    }

    public List<PluginInfo> getModuleInfos() {
        ArrayList<PluginInfo> modules = new ArrayList<PluginInfo>(this.modules);
        Collections.sort(modules, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        return modules;
    }

    public void addPlugin(PluginInfo info) {
        this.plugins.add(info);
    }

    public void addModule(PluginInfo info) {
        this.modules.add(info);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("plugins");
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            pluginInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray("modules");
        for (PluginInfo moduleInfo : this.getModuleInfos()) {
            moduleInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

