/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocValuesTermsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.internal.SearchContext;

class ParentChildInnerHitContextBuilder
extends InnerHitContextBuilder {
    private final String typeName;
    private final boolean fetchChildInnerHits;

    ParentChildInnerHitContextBuilder(String typeName, boolean fetchChildInnerHits, QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
        super(query, innerHitBuilder, children);
        this.typeName = typeName;
        this.fetchChildInnerHits = fetchChildInnerHits;
    }

    protected void doBuild(SearchContext parentSearchContext, InnerHitsContext innerHitsContext) throws IOException {
        if (parentSearchContext.mapperService().getIndexSettings().isSingleType()) {
            this.handleJoinFieldInnerHits(parentSearchContext, innerHitsContext);
        } else {
            this.handleParentFieldInnerHits(parentSearchContext, innerHitsContext);
        }
    }

    private void handleJoinFieldInnerHits(SearchContext context, InnerHitsContext innerHitsContext) throws IOException {
        QueryShardContext queryShardContext = context.getQueryShardContext();
        ParentJoinFieldMapper joinFieldMapper = ParentJoinFieldMapper.getMapper(context.mapperService());
        if (joinFieldMapper != null) {
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.typeName;
            JoinFieldInnerHitSubContext joinFieldInnerHits = new JoinFieldInnerHitSubContext(name, context, this.typeName, this.fetchChildInnerHits, joinFieldMapper);
            this.setupInnerHitsContext(queryShardContext, joinFieldInnerHits);
            innerHitsContext.addInnerHitDefinition((InnerHitsContext.InnerHitSubContext)joinFieldInnerHits);
        } else if (!this.innerHitBuilder.isIgnoreUnmapped()) {
            throw new IllegalStateException("no join field has been configured");
        }
    }

    private void handleParentFieldInnerHits(SearchContext context, InnerHitsContext innerHitsContext) throws IOException {
        QueryShardContext queryShardContext = context.getQueryShardContext();
        DocumentMapper documentMapper = queryShardContext.documentMapper(this.typeName);
        if (documentMapper == null) {
            if (!this.innerHitBuilder.isIgnoreUnmapped()) {
                throw new IllegalStateException("[" + this.query.getName() + "] no mapping found for type [" + this.typeName + "]");
            }
            return;
        }
        String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : documentMapper.type();
        ParentChildInnerHitSubContext parentChildInnerHits = new ParentChildInnerHitSubContext(name, context, queryShardContext.getMapperService(), documentMapper);
        this.setupInnerHitsContext(queryShardContext, parentChildInnerHits);
        innerHitsContext.addInnerHitDefinition((InnerHitsContext.InnerHitSubContext)parentChildInnerHits);
    }

    static final class ParentChildInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final MapperService mapperService;
        private final DocumentMapper documentMapper;

        ParentChildInnerHitSubContext(String name, SearchContext context, MapperService mapperService, DocumentMapper documentMapper) {
            super(name, context);
            this.mapperService = mapperService;
            this.documentMapper = documentMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TopDocs[] topDocs(SearchHit[] hits) throws IOException {
            Weight innerHitQueryWeight = this.createInnerHitQueryWeight();
            TopDocs[] result = new TopDocs[hits.length];
            for (int i = 0; i < hits.length; ++i) {
                Object hitQuery;
                SearchHit hit = hits[i];
                if (this.isParentHit(hit)) {
                    String field = ParentFieldMapper.joinField((String)hit.getType());
                    hitQuery = new DocValuesTermsQuery(field, new String[]{hit.getId()});
                } else if (this.isChildHit(hit)) {
                    DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hit.getType());
                    String parentType = hitDocumentMapper.parentFieldMapper().type();
                    DocumentField parentField = hit.field("_parent");
                    if (parentField == null) {
                        throw new IllegalStateException("All children must have a _parent");
                    }
                    Term uidTerm = this.context.mapperService().createUidTerm(parentType, (String)parentField.getValue());
                    hitQuery = uidTerm == null ? new MatchNoDocsQuery("Missing type: " + parentType) : new TermQuery(uidTerm);
                } else {
                    result[i] = Lucene.EMPTY_TOP_DOCS;
                    continue;
                }
                BooleanQuery q = new BooleanQuery.Builder().add((Query)hitQuery, BooleanClause.Occur.FILTER).add(this.documentMapper.typeFilter(this.context.getQueryShardContext()), BooleanClause.Occur.FILTER).build();
                Weight weight = this.context.searcher().createNormalizedWeight((Query)q, false);
                if (this.size() == 0) {
                    TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)totalHitCountCollector, (LeafReaderContext)ctx);
                    }
                    result[i] = new TopDocs((long)totalHitCountCollector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
                    continue;
                }
                int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
                Object topDocsCollector = this.sort() != null ? TopFieldCollector.create((Sort)this.sort().sort, (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores()) : TopScoreDocCollector.create((int)topN);
                try {
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)topDocsCollector, (LeafReaderContext)ctx);
                    }
                }
                finally {
                    this.clearReleasables(SearchContext.Lifetime.COLLECTION);
                }
                result[i] = topDocsCollector.topDocs(this.from(), this.size());
            }
            return result;
        }

        private boolean isParentHit(SearchHit hit) {
            return hit.getType().equals(this.documentMapper.parentFieldMapper().type());
        }

        private boolean isChildHit(SearchHit hit) {
            DocumentMapper hitDocumentMapper = this.mapperService.documentMapper(hit.getType());
            return this.documentMapper.type().equals(hitDocumentMapper.parentFieldMapper().type());
        }
    }

    static final class JoinFieldInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final String typeName;
        private final boolean fetchChildInnerHits;
        private final ParentJoinFieldMapper joinFieldMapper;

        JoinFieldInnerHitSubContext(String name, SearchContext context, String typeName, boolean fetchChildInnerHits, ParentJoinFieldMapper joinFieldMapper) {
            super(name, context);
            this.typeName = typeName;
            this.fetchChildInnerHits = fetchChildInnerHits;
            this.joinFieldMapper = joinFieldMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TopDocs[] topDocs(SearchHit[] hits) throws IOException {
            Weight innerHitQueryWeight = this.createInnerHitQueryWeight();
            TopDocs[] result = new TopDocs[hits.length];
            for (int i = 0; i < hits.length; ++i) {
                Query q;
                SearchHit hit = hits[i];
                String joinName = this.getSortedDocValue(this.joinFieldMapper.name(), this.context, hit.docId());
                if (joinName == null) {
                    result[i] = Lucene.EMPTY_TOP_DOCS;
                    continue;
                }
                QueryShardContext qsc = this.context.getQueryShardContext();
                ParentIdFieldMapper parentIdFieldMapper = this.joinFieldMapper.getParentIdFieldMapper(this.typeName, !this.fetchChildInnerHits);
                if (parentIdFieldMapper == null) {
                    result[i] = Lucene.EMPTY_TOP_DOCS;
                    continue;
                }
                if (this.fetchChildInnerHits) {
                    Query hitQuery = parentIdFieldMapper.fieldType().termQuery((Object)hit.getId(), qsc);
                    q = new BooleanQuery.Builder().add(hitQuery, BooleanClause.Occur.FILTER).add(this.joinFieldMapper.fieldType().termQuery(this.typeName, qsc), BooleanClause.Occur.FILTER).build();
                } else {
                    String parentId = this.getSortedDocValue(parentIdFieldMapper.name(), this.context, hit.docId());
                    q = this.context.mapperService().fullName("_id").termQuery((Object)parentId, qsc);
                }
                Weight weight = this.context.searcher().createNormalizedWeight(q, false);
                if (this.size() == 0) {
                    TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)totalHitCountCollector, (LeafReaderContext)ctx);
                    }
                    result[i] = new TopDocs((long)totalHitCountCollector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
                    continue;
                }
                int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
                Object topDocsCollector = this.sort() != null ? TopFieldCollector.create((Sort)this.sort().sort, (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores()) : TopScoreDocCollector.create((int)topN);
                try {
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)topDocsCollector, (LeafReaderContext)ctx);
                    }
                }
                finally {
                    this.clearReleasables(SearchContext.Lifetime.COLLECTION);
                }
                result[i] = topDocsCollector.topDocs(this.from(), this.size());
            }
            return result;
        }

        private String getSortedDocValue(String field, SearchContext context, int docId) {
            try {
                List ctxs = context.searcher().getIndexReader().leaves();
                LeafReaderContext ctx = (LeafReaderContext)ctxs.get(ReaderUtil.subIndex((int)docId, (List)ctxs));
                SortedDocValues docValues = ctx.reader().getSortedDocValues(field);
                int segmentDocId = docId - ctx.docBase;
                if (docValues == null || !docValues.advanceExact(segmentDocId)) {
                    return null;
                }
                int ord = docValues.ordValue();
                BytesRef joinName = docValues.lookupOrd(ord);
                return joinName.utf8ToString();
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }
    }
}

