/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.util.FileUtil;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.SwingUtilities;

public class GraphicsUtil {
    private GraphicsUtil() {
    }

    public static void saveImageAsJpeg(String filename, Image image) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
        GraphicsUtil.saveImageAsJpeg(filename, bufferedImage);
        bufferedImage.flush();
    }

    public static void saveImageAsJpeg(String filename, BufferedImage bufferedImage) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(FileUtil.normalizeFileName(filename)));
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bufferedImage);
        int quality = 100;
        param.setQuality((float)quality / 100.0f, false);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(bufferedImage);
        out.close();
    }

    public static void saveComponentAsJpeg(String filename, Component component, Container container) throws IOException {
        BufferedImage bufferedImage = GraphicsUtil.componentToImage(component, container);
        GraphicsUtil.saveImageAsJpeg(filename, bufferedImage);
        bufferedImage.flush();
    }

    public static BufferedImage componentToImage(Component component, Container container) throws IOException {
        Rectangle recComponent = component.getBounds();
        BufferedImage bufferedImage = new BufferedImage(recComponent.width, recComponent.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        SwingUtilities.paintComponent(graphics2D, component, container, 0, 0, recComponent.width, recComponent.height);
        return bufferedImage;
    }

    public static BufferedImage crop(BufferedImage bufferedImage, int x, int y, int width, int height) {
        BufferedImage retImage = new BufferedImage(width, height, 1);
        Graphics2D g = retImage.createGraphics();
        AffineTransform t = AffineTransform.getTranslateInstance(-x, -y);
        g.transform(t);
        g.drawImage(bufferedImage, null, 0, 0);
        return retImage;
    }
}

