/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.CannotResolveClassException;
import com.thoughtworks.xstream.alias.ClassMapper;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class DefaultClassMapper
implements ClassMapper {
    protected Map typeToNameMap = new HashMap();
    protected Map nameToTypeMap = new HashMap();
    protected Map baseTypeToDefaultTypeMap = new HashMap();
    private Map lookupTypeCache = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy;

    public DefaultClassMapper() {
        this.baseTypeToDefaultTypeMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultClassMapper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.baseTypeToDefaultTypeMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = DefaultClassMapper.class$("java.lang.Character")) : class$java$lang$Character);
        this.baseTypeToDefaultTypeMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultClassMapper.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.baseTypeToDefaultTypeMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = DefaultClassMapper.class$("java.lang.Float")) : class$java$lang$Float);
        this.baseTypeToDefaultTypeMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = DefaultClassMapper.class$("java.lang.Double")) : class$java$lang$Double);
        this.baseTypeToDefaultTypeMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = DefaultClassMapper.class$("java.lang.Short")) : class$java$lang$Short);
        this.baseTypeToDefaultTypeMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultClassMapper.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.baseTypeToDefaultTypeMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = DefaultClassMapper.class$("java.lang.Long")) : class$java$lang$Long);
    }

    public String mapNameToXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                stringBuffer.append("_DOLLAR_");
                continue;
            }
            if (c == '_') {
                stringBuffer.append("__");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String mapNameFromXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                if (string.charAt(i + 1) == '_') {
                    ++i;
                    stringBuffer.append('_');
                    continue;
                }
                if (!string.substring(i + 1, i + 8).equals("DOLLAR_")) continue;
                i += 7;
                stringBuffer.append('$');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void alias(String string, Class clazz, Class clazz2) {
        this.nameToTypeMap.put(string, clazz.getName());
        this.typeToNameMap.put(clazz, string);
        if (!clazz.equals(clazz2)) {
            this.typeToNameMap.put(clazz2, string);
        }
        this.baseTypeToDefaultTypeMap.put(clazz, clazz2);
    }

    public String lookupName(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            stringBuffer.append("-array");
        }
        String string = (String)this.typeToNameMap.get(clazz);
        if (string == null && Proxy.isProxyClass(clazz)) {
            string = (String)this.typeToNameMap.get(class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy = DefaultClassMapper.class$("com.thoughtworks.xstream.alias.ClassMapper$DynamicProxy")) : class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy);
        }
        if (string == null && (string = clazz.getName().replace('$', '-')).charAt(0) == '-') {
            string = "default" + string;
        }
        if (stringBuffer.length() > 0) {
            string = string + stringBuffer.toString();
        }
        return string;
    }

    private Class primitiveClassNamed(String string) {
        return string.equals("void") ? Void.TYPE : (string.equals("boolean") ? Boolean.TYPE : (string.equals("byte") ? Byte.TYPE : (string.equals("char") ? Character.TYPE : (string.equals("short") ? Short.TYPE : (string.equals("int") ? Integer.TYPE : (string.equals("long") ? Long.TYPE : (string.equals("float") ? Float.TYPE : (string.equals("double") ? Double.TYPE : null))))))));
    }

    public Class lookupType(String string) {
        Class clazz;
        String string2 = string;
        if (string.equals("null")) {
            return null;
        }
        if (this.lookupTypeCache.containsKey(string2)) {
            return (Class)this.lookupTypeCache.get(string2);
        }
        int n = 0;
        while (string.endsWith("-array")) {
            string = string.substring(0, string.length() - 6);
            ++n;
        }
        Class clazz2 = null;
        if (n > 0) {
            clazz2 = this.primitiveClassNamed(string);
        }
        String string3 = null;
        if (clazz2 == null) {
            string3 = (String)this.nameToTypeMap.get(this.mapNameFromXML(string));
        }
        if (string3 != null) {
            string = string3;
        }
        if ((string = string.replace('-', '$')).startsWith("default$")) {
            string = string.substring(7);
        }
        try {
            if (n > 0) {
                if (clazz2 != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append('[');
                    }
                    stringBuffer.append(this.charThatJavaUsesToRepresentPrimitiveType(clazz2));
                    clazz = this.loadClass(stringBuffer.toString());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append('[');
                    }
                    stringBuffer.append('L').append(string).append(';');
                    clazz = this.loadClass(stringBuffer.toString());
                }
            } else {
                clazz = this.loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CannotResolveClassException(string + " : " + classNotFoundException.getMessage());
        }
        this.lookupTypeCache.put(string2, clazz);
        return clazz;
    }

    private Class loadClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
    }

    private char charThatJavaUsesToRepresentPrimitiveType(Class clazz) {
        return (char)(clazz == Boolean.TYPE ? 90 : (clazz == Byte.TYPE ? 66 : (clazz == Character.TYPE ? 67 : (clazz == Short.TYPE ? 83 : (clazz == Integer.TYPE ? 73 : (clazz == Long.TYPE ? 74 : (clazz == Float.TYPE ? 70 : (clazz == Double.TYPE ? 68 : 0))))))));
    }

    public Class lookupDefaultType(Class clazz) {
        Class clazz2 = (Class)this.baseTypeToDefaultTypeMap.get(clazz);
        return clazz2 == null ? clazz : clazz2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

