/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class LDAPDN {
    public static String[] explodeDN(String string, boolean bl) {
        DN dN = new DN(string);
        return dN.explodeDN(bl);
    }

    public static String[] explodeRDN(String string, boolean bl) {
        RDN rDN = new RDN(string);
        if (bl) {
            return rDN.getValues();
        }
        String[] stringArray = new String[]{rDN.toString()};
        return stringArray;
    }

    public static String escapeRDN(String string) {
        RDN rDN = new RDN(string);
        String[] stringArray = rDN.getValues();
        if (stringArray == null) {
            return string;
        }
        StringBuffer[] stringBufferArray = new StringBuffer[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = rDN.getTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBufferArray[i] = new StringBuffer(stringArray[i]);
            for (int j = 0; j < stringBufferArray[i].length(); ++j) {
                if (!LDAPDN.isEscape(stringBufferArray[i].charAt(j))) continue;
                stringBufferArray[i].insert(j, '\\');
                ++j;
            }
            stringBuffer.append((stringBuffer.length() > 0 ? " + " : "") + stringArray2[i] + "=" + new String(stringBufferArray[i]));
        }
        return new String(stringBuffer);
    }

    public static String unEscapeRDN(String string) {
        RDN rDN = new RDN(string);
        String[] stringArray = rDN.getValues();
        if (stringArray == null || stringArray.length < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringBuffer.length()) {
            char c;
            if ((c = stringBuffer.charAt(n++)) != '\\') {
                stringBuffer2.append(c);
                continue;
            }
            if (n >= stringBuffer.length()) continue;
            stringBuffer2.append(stringBuffer.charAt(n++));
        }
        return rDN.getTypes()[0] + "=" + new String(stringBuffer2);
    }

    public static String normalize(String string) {
        return new DN(string).toString();
    }

    public static boolean equals(String string, String string2) {
        return LDAPDN.normalize(string).equals(LDAPDN.normalize(string2));
    }

    private static boolean isEscape(char c) {
        for (int i = 0; i < DN.ESCAPED_CHAR.length; ++i) {
            if (c != DN.ESCAPED_CHAR[i]) continue;
            return true;
        }
        return false;
    }
}

