/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Fields in Guice modules should be final", severity=BugPattern.SeverityLevel.WARNING)
public class MutableGuiceModule
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private final WellKnownMutability wellKnownMutability;
    private static final Supplier<Symbol> ABSTRACT_MODULE = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("com.google.inject.AbstractModule"));

    @Inject
    MutableGuiceModule(WellKnownMutability wellKnownMutability) {
        this.wellKnownMutability = wellKnownMutability;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (!sym.getKind().equals((Object)ElementKind.FIELD)) {
            return Description.NO_MATCH;
        }
        Symbol abstractModule = (Symbol)ABSTRACT_MODULE.get(state);
        if (abstractModule == null) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.enclosingClass((Symbol)sym).isSubClass(abstractModule, state.getTypes())) {
            return Description.NO_MATCH;
        }
        if (sym.isStatic()) {
            return Description.NO_MATCH;
        }
        if (!tree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            Description.Builder description = this.buildDescription(tree);
            SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).filter(f -> SuggestedFixes.compilesWithFix((Fix)f, (VisitorState)state)).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
            state.reportMatch(description.build());
        }
        Type type = ASTHelpers.getType((Tree)tree);
        String nameStr = type.tsym.flatName().toString();
        if (this.wellKnownMutability.getKnownMutableClasses().contains((Object)nameStr)) {
            state.reportMatch(this.buildDescription(tree).setMessage(String.format("Fields in Guice modules should be immutable, but %s is mutable", SuggestedFixes.prettyType((Type)type, (VisitorState)state))).build());
        }
        return Description.NO_MATCH;
    }
}

