/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="You should almost never invoke the Enum.ordinal() method.", severity=BugPattern.SeverityLevel.WARNING)
public final class EnumOrdinal
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ORDINAL = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Enum").named("ordinal");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (ORDINAL.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

