/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.errorprone.matchers.method.ConstructorMatchState;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Symbol;
import org.jspecify.annotations.Nullable;

interface BaseMethodMatcher {
    public static final BaseMethodMatcher METHOD = tree -> {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return null;
        }
        if (tree instanceof NewClassTree) {
            return null;
        }
        if (tree instanceof MethodInvocationTree) {
            tree = ((MethodInvocationTree)tree).getMethodSelect();
        }
        return MethodMatchState.create(tree, (Symbol.MethodSymbol)sym);
    };
    public static final BaseMethodMatcher CONSTRUCTOR = tree -> {
        switch (tree.getKind()) {
            case NEW_CLASS: 
            case METHOD_INVOCATION: 
            case MEMBER_REFERENCE: {
                break;
            }
            default: {
                return null;
            }
        }
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return null;
        }
        Symbol.MethodSymbol method = (Symbol.MethodSymbol)sym;
        if (!method.isConstructor()) {
            return null;
        }
        return ConstructorMatchState.create(method);
    };

    public @Nullable MatchState match(ExpressionTree var1);
}

