/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.VariableCleaner;
import proguard.classfile.editor.VariableRemapper;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.LivenessAnalyzer;

public class VariableOptimizer
implements AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final Logger logger = LogManager.getLogger(VariableOptimizer.class);
    private static final int MAX_VARIABLES_SIZE = 64;
    private final boolean reuseThis;
    private final MemberVisitor extraVariableMemberVisitor;
    private final LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer();
    private final VariableRemapper variableRemapper = new VariableRemapper();
    private VariableCleaner variableCleaner = new VariableCleaner();
    private int[] variableMap = new int[64];

    public VariableOptimizer(boolean reuseThis) {
        this(reuseThis, null);
    }

    public VariableOptimizer(boolean reuseThis, MemberVisitor extraVariableMemberVisitor) {
        this.reuseThis = reuseThis;
        this.extraVariableMemberVisitor = extraVariableMemberVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.initializeArrays(codeAttribute);
        this.livenessAnalyzer.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
        int startIndex = (method.getAccessFlags() & 8) != 0 || this.reuseThis ? 0 : 1;
        int parameterSize = ClassUtil.internalMethodParameterSize((String)method.getDescriptor(clazz), (int)method.getAccessFlags());
        int variableSize = codeAttribute.u2maxLocals;
        int codeLength = codeAttribute.u4codeLength;
        boolean remapping = false;
        block0: for (int oldIndex = 0; oldIndex < variableSize; ++oldIndex) {
            this.variableMap[oldIndex] = oldIndex;
            if (oldIndex < parameterSize || oldIndex >= 64) continue;
            for (int newIndex = startIndex; newIndex < oldIndex; ++newIndex) {
                if (!this.areNonOverlapping(oldIndex, newIndex, codeLength)) continue;
                this.variableMap[oldIndex] = newIndex;
                this.updateLiveness(oldIndex, newIndex, codeLength);
                remapping = true;
                continue block0;
            }
        }
        if (remapping) {
            logger.debug("VariableOptimizer: {}.{}{}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
            for (int index = 0; index < variableSize; ++index) {
                logger.debug("  v{} -> {}", (Object)index, (Object)this.variableMap[index]);
            }
            this.variableRemapper.setVariableMap(this.variableMap);
            this.variableRemapper.visitCodeAttribute(clazz, method, codeAttribute);
            if (this.extraVariableMemberVisitor != null) {
                method.accept(clazz, this.extraVariableMemberVisitor);
            }
        } else {
            this.variableCleaner.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableInfoVisitor)this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableTypeInfoVisitor)this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        int variable = localVariableInfo.u2index;
        int startPC = localVariableInfo.u2startPC;
        int endPC = startPC + localVariableInfo.u2length;
        int length = (endPC = this.lastLiveness(startPC = this.firstLiveness(startPC, endPC, variable), endPC, variable)) - startPC;
        if (length > 0) {
            localVariableInfo.u2startPC = startPC;
        }
        localVariableInfo.u2length = length;
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        int variable = localVariableTypeInfo.u2index;
        int startPC = localVariableTypeInfo.u2startPC;
        int endPC = startPC + localVariableTypeInfo.u2length;
        int length = (endPC = this.lastLiveness(startPC = this.firstLiveness(startPC, endPC, variable), endPC, variable)) - startPC;
        if (length > 0) {
            localVariableTypeInfo.u2startPC = startPC;
        }
        localVariableTypeInfo.u2length = length;
    }

    private void initializeArrays(CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.variableMap.length < codeLength) {
            this.variableMap = new int[codeLength];
        }
    }

    private boolean areNonOverlapping(int variableIndex1, int variableIndex2, int codeLength) {
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!(this.livenessAnalyzer.isAliveBefore(offset, variableIndex1) && this.livenessAnalyzer.isAliveBefore(offset, variableIndex2) || this.livenessAnalyzer.isAliveAfter(offset, variableIndex1) && this.livenessAnalyzer.isAliveAfter(offset, variableIndex2)) && !this.livenessAnalyzer.isCategory2(offset, variableIndex1)) continue;
            return false;
        }
        return true;
    }

    private void updateLiveness(int oldVariableIndex, int newVariableIndex, int codeLength) {
        for (int offset = 0; offset < codeLength; ++offset) {
            if (this.livenessAnalyzer.isAliveBefore(offset, oldVariableIndex)) {
                this.livenessAnalyzer.setAliveBefore(offset, oldVariableIndex, false);
                this.livenessAnalyzer.setAliveBefore(offset, newVariableIndex, true);
            }
            if (!this.livenessAnalyzer.isAliveAfter(offset, oldVariableIndex)) continue;
            this.livenessAnalyzer.setAliveAfter(offset, oldVariableIndex, false);
            this.livenessAnalyzer.setAliveAfter(offset, newVariableIndex, true);
        }
    }

    private int firstLiveness(int startOffset, int endOffset, int variableIndex) {
        for (int offset = startOffset; offset < endOffset; ++offset) {
            if (!this.livenessAnalyzer.isTraced(offset) || !this.livenessAnalyzer.isAliveBefore(offset, variableIndex)) continue;
            return offset;
        }
        return endOffset;
    }

    private int lastLiveness(int startOffset, int endOffset, int variableIndex) {
        int previousOffset = endOffset;
        for (int offset = endOffset - 1; offset >= startOffset; --offset) {
            if (!this.livenessAnalyzer.isTraced(offset)) continue;
            if (this.livenessAnalyzer.isAliveBefore(offset, variableIndex)) {
                return previousOffset;
            }
            previousOffset = offset;
        }
        return endOffset;
    }
}

