/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import proguard.util.ListUtil;

public class ClassPathEntry {
    private File file;
    private boolean output;
    private String featureName;
    private List<String> filter;
    private List<String> apkFilter;
    private List<String> aabFilter;
    private List<String> jarFilter;
    private List<String> aarFilter;
    private List<String> warFilter;
    private List<String> earFilter;
    private List<String> jmodFilter;
    private List<String> zipFilter;
    private String cachedName;

    public ClassPathEntry(File file, boolean isOutput) {
        this.file = file;
        this.output = isOutput;
    }

    public ClassPathEntry(File file, boolean isOutput, String featureName) {
        this.file = file;
        this.output = isOutput;
        this.featureName = featureName;
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.getUncachedName();
        }
        return this.cachedName;
    }

    private String getUncachedName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            return this.file.getPath();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.cachedName = null;
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public boolean isDex() {
        return this.hasExtension(".dex");
    }

    public boolean isApk() {
        return this.hasExtension(".apk") || this.hasExtension(".ap_");
    }

    public boolean isAab() {
        return this.hasExtension(".aab");
    }

    public boolean isJar() {
        return this.hasExtension(".jar");
    }

    public boolean isAar() {
        return this.hasExtension(".aar");
    }

    public boolean isWar() {
        return this.hasExtension(".war");
    }

    public boolean isEar() {
        return this.hasExtension(".ear");
    }

    public boolean isJmod() {
        return this.hasExtension(".jmod");
    }

    public boolean isZip() {
        return this.hasExtension(".zip");
    }

    private boolean hasExtension(String extension) {
        return ClassPathEntry.endsWithIgnoreCase(this.file.getPath(), extension);
    }

    private static boolean endsWithIgnoreCase(String string, String suffix) {
        int stringLength = string.length();
        int suffixLength = suffix.length();
        return string.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }

    public boolean isFiltered() {
        return this.filter != null || this.apkFilter != null || this.aabFilter != null || this.jarFilter != null || this.aarFilter != null || this.warFilter != null || this.earFilter != null || this.jmodFilter != null || this.zipFilter != null;
    }

    public List<String> getFilter() {
        return this.filter;
    }

    public void setFilter(List<String> filter) {
        this.filter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getApkFilter() {
        return this.apkFilter;
    }

    public void setApkFilter(List<String> filter) {
        this.apkFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getAabFilter() {
        return this.aabFilter;
    }

    public void setAabFilter(List<String> filter) {
        this.aabFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getJarFilter() {
        return this.jarFilter;
    }

    public void setJarFilter(List<String> filter) {
        this.jarFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getAarFilter() {
        return this.aarFilter;
    }

    public void setAarFilter(List<String> filter) {
        this.aarFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getWarFilter() {
        return this.warFilter;
    }

    public void setWarFilter(List<String> filter) {
        this.warFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getEarFilter() {
        return this.earFilter;
    }

    public void setEarFilter(List<String> filter) {
        this.earFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getJmodFilter() {
        return this.jmodFilter;
    }

    public void setJmodFilter(List<String> filter) {
        this.jmodFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public List<String> getZipFilter() {
        return this.zipFilter;
    }

    public void setZipFilter(List<String> filter) {
        this.zipFilter = filter == null || filter.size() == 0 ? null : filter;
    }

    public String toString() {
        String string = this.getName();
        if (this.filter != null || this.apkFilter != null || this.aabFilter != null || this.jarFilter != null || this.aarFilter != null || this.warFilter != null || this.earFilter != null || this.jmodFilter != null || this.zipFilter != null) {
            string = string + "(" + (this.aarFilter != null ? ListUtil.commaSeparatedString(this.aarFilter, true) : "") + ";" + (this.aabFilter != null ? ListUtil.commaSeparatedString(this.aabFilter, true) : "") + ";" + (this.apkFilter != null ? ListUtil.commaSeparatedString(this.apkFilter, true) : "") + ";" + (this.zipFilter != null ? ListUtil.commaSeparatedString(this.zipFilter, true) : "") + ";" + (this.jmodFilter != null ? ListUtil.commaSeparatedString(this.jmodFilter, true) : "") + ";" + (this.earFilter != null ? ListUtil.commaSeparatedString(this.earFilter, true) : "") + ";" + (this.warFilter != null ? ListUtil.commaSeparatedString(this.warFilter, true) : "") + ";" + (this.jarFilter != null ? ListUtil.commaSeparatedString(this.jarFilter, true) : "") + ";" + (this.filter != null ? ListUtil.commaSeparatedString(this.filter, true) : "") + ")";
        }
        return string;
    }
}

