/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.connection;

import com.google.caliper.bridge.OpenedSocket;
import com.google.caliper.util.Uuids;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class ClientConnectionService
extends AbstractIdleService {
    private final UUID id;
    private final InetSocketAddress clientAddress;
    private volatile SocketChannel channel;
    private volatile OpenedSocket.Reader reader;
    private volatile OpenedSocket.Writer writer;

    @Inject
    ClientConnectionService(UUID id, InetSocketAddress clientAddress) {
        this.id = id;
        this.clientAddress = clientAddress;
    }

    protected void startUp() throws IOException {
        this.channel = SocketChannel.open(this.clientAddress);
        Uuids.writeToChannel((UUID)this.id, (WritableByteChannel)this.channel);
        OpenedSocket openedSocket = OpenedSocket.fromSocket((SocketChannel)this.channel);
        this.writer = openedSocket.writer();
        this.reader = openedSocket.reader();
    }

    protected void shutDown() throws IOException {
        try {
            try {
                this.reader.close();
            }
            finally {
                this.writer.close();
            }
        }
        finally {
            this.channel.close();
        }
    }

    public void send(Serializable ... messages) throws IOException {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"send() may only be called when the service is running");
        this.writer.write(messages);
    }

    public Object receive() throws IOException {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"receive() may only be called when the service is running");
        return this.reader.read();
    }
}

