/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.in.TextInput;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.fn.ParseFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.util.options.Options;

public abstract class ParseJson
extends ParseFn {
    protected abstract JsonOptions.JsonFormat format();

    @Override
    final QueryError error() {
        return QueryError.PARSE_JSON_X;
    }

    @Override
    protected final Options options(QueryContext qc) throws QueryException {
        return this.toOptions(this.arg(1), new JsonParserOptions(), qc);
    }

    @Override
    public final int hofOffsets() {
        return this.defined(1) ? Integer.MAX_VALUE : 0;
    }

    @Override
    final Value parse(TextInput ti, Options options, QueryContext qc) throws QueryException, IOException {
        Value nll;
        Value numberParser;
        JsonOptions.JsonFormat format = this.format();
        if (format != null) {
            options.set(JsonOptions.FORMAT, format);
        }
        JsonConverter converter = JsonConverter.get((JsonParserOptions)options);
        JsonOptions.JsonFormat jf = options.get(JsonOptions.FORMAT);
        if (options.get(JsonParserOptions.VALIDATE) != null && jf != JsonOptions.JsonFormat.W3_XML && jf != JsonOptions.JsonFormat.BASIC) {
            throw QueryError.INVALIDOPTION_X.get(this.info, Options.unknown(JsonParserOptions.VALIDATE));
        }
        Value fallback = options.get(JsonParserOptions.FALLBACK);
        if (!fallback.isEmpty()) {
            FItem fb = this.toFunction(fallback, 1, qc);
            converter.fallback(s -> this.toAtomItem(fb.invoke(qc, this.info, Str.get(s)), qc).string(this.info));
            if (options.get(JsonParserOptions.ESCAPE).booleanValue()) {
                throw QueryError.OPTION_JSON_X.get(this.info, "Escape cannot be combined with fallback function.");
            }
        }
        if (!(numberParser = options.get(JsonParserOptions.NUMBER_PARSER)).isEmpty()) {
            FItem np = this.toFunction(numberParser, 1, qc);
            converter.numberParser(s -> np.invoke(qc, this.info, Atm.get(s)).item(qc, this.info));
        }
        if ((nll = options.get(JsonParserOptions.NULL)) != Empty.VALUE && jf != JsonOptions.JsonFormat.W3 && jf != JsonOptions.JsonFormat.XQUERY) {
            throw QueryError.INVALIDOPTION_X.get(this.info, Options.unknown(JsonParserOptions.NULL));
        }
        converter.nullValue(nll);
        return converter.convert(ti, "", this.info, qc);
    }
}

