/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.core.BaseXException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Pragma;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.item.QNm;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.Option;

public final class DBPragma
extends Pragma {
    private final Option<?> option;

    public DBPragma(QNm name, Option<?> option, byte[] value) {
        super(name, value);
        this.option = option;
    }

    @Override
    Object init(QueryContext qc, InputInfo info) throws QueryException {
        Object old = qc.context.options.get(this.option);
        try {
            qc.context.options.assign(this.option.name(), Token.string(this.value));
        }
        catch (BaseXException ex) {
            Util.debug(ex);
            throw QueryError.BASEX_OPTIONS_X_X.get(info, this.option.name(), this.value);
        }
        return old;
    }

    @Override
    void finish(QueryContext qc, Object state) {
        qc.context.options.put(this.option, state);
    }

    @Override
    public boolean has(Flag ... flags) {
        return false;
    }

    @Override
    public void accept(ASTVisitor visitor) {
    }

    @Override
    public Pragma copy() {
        return new DBPragma(this.name, this.option, this.value);
    }

    @Override
    public boolean simplify() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DBPragma)) return false;
        DBPragma db = (DBPragma)obj;
        if (!this.option.equals(db.option)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }
}

