/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net.xqj.basic.BasicConnection;
import net.xqj.basic.BasicQuery;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.XQDynamicContextImpl;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.XQItemProxy;
import net.xqj.core.xqparser.XQueryStatement;
import net.xqj.core.xqsequence.XQSequenceProxy;

public class XQPreparedExpression3
extends XQDynamicContextImpl
implements XQPreparedExpression {
    private static int instanceCounter = 0;
    private final int instanceId = ++instanceCounter;
    private final XQueryStatement queryStatement;
    private boolean isCancelled = false;
    private Thread executionThread = null;

    private XQPreparedExpression3(GenericXQConnection connection, Reader originalQuery, XQStaticContext staticContext) throws XQException {
        super(connection, staticContext);
        this.queryStatement = XQueryStatement.compile(originalQuery, staticContext);
    }

    static XQPreparedExpression3 newInstance(GenericXQConnection connection, Reader originalQuery, XQStaticContext staticContext) throws XQException {
        return new XQPreparedExpression3(connection, originalQuery, staticContext);
    }

    public XQResultSequence executeQuery() throws XQException {
        if (this.conn.getDataSource().getLogger().isTraceLoggable()) {
            this.conn.getDataSource().getLogger().log(5, XQToolkit.formatMessage(14, this.toString(), new String(this.queryStatement.getQuery())));
        }
        this.checkIfClosed();
        this.executionThread = Thread.currentThread();
        BasicConnection bc = this.conn.getBasicConnection();
        BasicQuery outputQuery = bc.createQuery();
        try {
            this.resolveQuery(this.queryStatement, outputQuery);
        }
        catch (IOException e) {
            throw new XQExceptionImpl("IOException occurred.", "XQJPE001", e);
        }
        if (this.conn.getDataSource().getLogger().isTraceLoggable()) {
            ByteBuffer buffer = outputQuery.getCompleteQuery();
            byte[] b = new byte[buffer.limit()];
            buffer.get(b);
            this.conn.getDataSource().getLogger().log(5, XQToolkit.formatMessage(15, this.toString(), XQToolkit.getUTF8String(b)));
        }
        return this.executeQuery(bc, outputQuery);
    }

    public QName[] getAllExternalVariables() throws XQException {
        this.checkIfClosed();
        return this.queryStatement.getAllExternalVariables();
    }

    public QName[] getAllUnboundExternalVariables() throws XQException {
        this.checkIfClosed();
        HashSet set1 = new HashSet(this.queryStatement.getAllExternalVariablesAsSet());
        Set set2 = this.boundVariables.keySet();
        set1.removeAll(set2);
        return set1.toArray(new QName[set1.size()]);
    }

    public XQSequenceType getStaticResultType() throws XQException {
        this.checkIfClosed();
        return this.conn.createSequenceType(this.conn.createItemType(), 3);
    }

    public XQSequenceType getStaticVariableType(QName name) throws XQException {
        this.checkIfClosed();
        XQToolkit.nullValueTest(name, "QName", "XQJPE003");
        XQSequenceType xqst = this.queryStatement.getStaticVariableType(name);
        if (xqst != null) {
            return xqst;
        }
        if (name.equals(XQConstants.CONTEXT_ITEM)) {
            return this.getStaticContext().getContextItemStaticType();
        }
        throw new XQExceptionImpl("Variable " + name + " is not defined in the prolog of the XQuery.", "XQJPE002");
    }

    @Override
    public XQStaticContext getStaticContext() throws XQException {
        this.checkIfClosed();
        return this.staticContext;
    }

    @Override
    protected void validateBinding(QName varName, XQItemProxy proxy) throws XQException {
        XQSequenceType staticVariableType = this.getStaticVariableType(varName);
        XQItemType dynamicVariableType = proxy.getItemType();
    }

    @Override
    protected void validateBinding(QName varName, XQSequenceProxy proxy) throws XQException {
        XQSequenceType staticVariableType = this.getStaticVariableType(varName);
        XQItemType dynamicVariableType = proxy.getItemType();
    }

    public String toString() {
        return "XQPreparedExpression-" + this.instanceId;
    }
}

