/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.name;

import java.io.IOException;
import org.basex.core.cmd.Copy;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.name.NameUpdate;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class DBCopy
extends NameUpdate {
    private final StringList targets = new StringList();

    public DBCopy(String name, String target, QueryContext qc, InputInfo info) {
        super(UpdateType.DBCOPY, name, qc, info);
        this.targets.add(target);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() throws QueryException {
        this.close();
        try {
            for (String target : this.targets) {
                DBCopy.close(target, this.qc, this.info);
                Copy.copy(this.name, target, this.qc.context.soptions, null);
            }
        }
        catch (IOException ex) {
            throw QueryError.UPDBERROR_X.get(this.info, ex);
        }
    }

    @Override
    public void merge(Update update) throws QueryException {
        for (String target : ((DBCopy)update).targets) {
            if (this.targets.contains(target)) {
                throw QueryError.DB_CONFLICT1_X_X.get(this.info, target, this.operation());
            }
            this.targets.add(target);
        }
    }

    @Override
    public void databases(StringList db) {
        super.databases(db);
        for (String target : this.targets) {
            db.add(target);
        }
    }

    @Override
    public String operation() {
        return "copied";
    }
}

